<?php //d797fd668402e2082fb9c5df7767866a
/** @noinspection all */

namespace App\Models {

    use Database\Factories\UserFactory;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\HasMany;
    use Illuminate\Database\Eloquent\Relations\MorphToMany;
    use Illuminate\Notifications\DatabaseNotification;
    use Illuminate\Notifications\DatabaseNotificationCollection;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\App\Models\_IH_Admin_C;
    use LaravelIdea\Helper\App\Models\_IH_Admin_QB;
    use LaravelIdea\Helper\App\Models\_IH_Currency_C;
    use LaravelIdea\Helper\App\Models\_IH_Currency_QB;
    use LaravelIdea\Helper\App\Models\_IH_DepositMethod_C;
    use LaravelIdea\Helper\App\Models\_IH_DepositMethod_QB;
    use LaravelIdea\Helper\App\Models\_IH_Language_C;
    use LaravelIdea\Helper\App\Models\_IH_Language_QB;
    use LaravelIdea\Helper\App\Models\_IH_PaymentGateway_C;
    use LaravelIdea\Helper\App\Models\_IH_PaymentGateway_QB;
    use LaravelIdea\Helper\App\Models\_IH_Plugin_C;
    use LaravelIdea\Helper\App\Models\_IH_Plugin_QB;
    use LaravelIdea\Helper\App\Models\_IH_Setting_C;
    use LaravelIdea\Helper\App\Models\_IH_Setting_QB;
    use LaravelIdea\Helper\App\Models\_IH_Staff_C;
    use LaravelIdea\Helper\App\Models\_IH_Staff_QB;
    use LaravelIdea\Helper\App\Models\_IH_User_C;
    use LaravelIdea\Helper\App\Models\_IH_User_QB;
    use LaravelIdea\Helper\App\Models\_IH_Wallet_C;
    use LaravelIdea\Helper\App\Models\_IH_Wallet_QB;
    use LaravelIdea\Helper\Illuminate\Notifications\_IH_DatabaseNotification_QB;
    use LaravelIdea\Helper\Spatie\Permission\Models\_IH_Permission_C;
    use LaravelIdea\Helper\Spatie\Permission\Models\_IH_Permission_QB;
    use LaravelIdea\Helper\Spatie\Permission\Models\_IH_Role_C;
    use LaravelIdea\Helper\Spatie\Permission\Models\_IH_Role_QB;
    use Spatie\Permission\Models\Permission;
    use Spatie\Permission\Models\Role;
    
    /**
     * @property int $id
     * @property string|null $avatar
     * @property string $name
     * @property string $email
     * @property Carbon|null $email_verified_at
     * @property mixed $password
     * @property bool $status
     * @property string|null $remember_token
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_Permission_C|Permission[] $permissions
     * @property-read int $permissions_count
     * @method MorphToMany|_IH_Permission_QB permissions()
     * @property _IH_Role_C|Role[] $roles
     * @property-read int $roles_count
     * @method MorphToMany|_IH_Role_QB roles()
     * @method static _IH_Admin_QB onWriteConnection()
     * @method _IH_Admin_QB newQuery()
     * @method static _IH_Admin_QB on(null|string $connection = null)
     * @method static _IH_Admin_QB query()
     * @method static _IH_Admin_QB with(array|string $relations)
     * @method _IH_Admin_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Admin_C|Admin[] all()
     * @mixin _IH_Admin_QB
     */
    class Admin extends Model {}
    
    /**
     * @property int $id
     * @property string|null $flag
     * @property string $name
     * @property string $code
     * @property string $symbol
     * @property string $type
     * @property string $exchange_rate
     * @property bool $rate_live
     * @property array $role
     * @property bool $default
     * @property bool $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Currency_QB onWriteConnection()
     * @method _IH_Currency_QB newQuery()
     * @method static _IH_Currency_QB on(null|string $connection = null)
     * @method static _IH_Currency_QB query()
     * @method static _IH_Currency_QB with(array|string $relations)
     * @method _IH_Currency_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Currency_C|Currency[] all()
     * @foreignLinks id,\App\Models\Wallet,currency_id
     * @mixin _IH_Currency_QB
     */
    class Currency extends Model {}
    
    /**
     * @property int $id
     * @property int $payment_gateway_id Payment gateway id
     * @property string $icon
     * @property string $name
     * @property string $type auto = automatic, manual = manual
     * @property string $code
     * @property string $currency
     * @property string $currency_symbol
     * @property float $min_limit
     * @property float $max_limit
     * @property string $rate_type fixed = fixed rate, live = live rate
     * @property float $rate
     * @property string $charge_type fixed = fixed charge, percent = percent charge
     * @property float $charge
     * @property array $fields
     * @property string $notes
     * @property bool $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read string $conversion_rate attribute
     * @property-read string $logo attribute
     * @property PaymentGateway $paymentGateway
     * @method BelongsTo|_IH_PaymentGateway_QB paymentGateway()
     * @method static _IH_DepositMethod_QB onWriteConnection()
     * @method _IH_DepositMethod_QB newQuery()
     * @method static _IH_DepositMethod_QB on(null|string $connection = null)
     * @method static _IH_DepositMethod_QB query()
     * @method static _IH_DepositMethod_QB with(array|string $relations)
     * @method _IH_DepositMethod_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_DepositMethod_C|DepositMethod[] all()
     * @ownLinks payment_gateway_id,\App\Models\PaymentGateway,id
     * @mixin _IH_DepositMethod_QB
     */
    class DepositMethod extends Model {}
    
    /**
     * @property int $id
     * @property string $flag
     * @property string $name
     * @property string $code
     * @property bool $is_default
     * @property bool $is_rtl
     * @property bool $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Language_QB onWriteConnection()
     * @method _IH_Language_QB newQuery()
     * @method static _IH_Language_QB on(null|string $connection = null)
     * @method static _IH_Language_QB query()
     * @method static _IH_Language_QB with(array|string $relations)
     * @method _IH_Language_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Language_C|Language[] all()
     * @mixin _IH_Language_QB
     */
    class Language extends Model {}
    
    /**
     * @property int $id
     * @property string|null $logo
     * @property string $name
     * @property string $code Code for payment gateway e.g. paypal, stripe, razorpay
     * @property array $currencies Json encoded currencies
     * @property array $credentials Json encoded credentials
     * @property string|null $is_withdraw
     * @property bool $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_PaymentGateway_QB onWriteConnection()
     * @method _IH_PaymentGateway_QB newQuery()
     * @method static _IH_PaymentGateway_QB on(null|string $connection = null)
     * @method static _IH_PaymentGateway_QB query()
     * @method static _IH_PaymentGateway_QB with(array|string $relations)
     * @method _IH_PaymentGateway_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_PaymentGateway_C|PaymentGateway[] all()
     * @foreignLinks id,\App\Models\DepositMethod,payment_gateway_id
     * @mixin _IH_PaymentGateway_QB
     */
    class PaymentGateway extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property string $type
     * @property string $logo
     * @property string $description
     * @property string $credentials
     * @property string|null $fields
     * @property bool $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Plugin_QB onWriteConnection()
     * @method _IH_Plugin_QB newQuery()
     * @method static _IH_Plugin_QB on(null|string $connection = null)
     * @method static _IH_Plugin_QB query()
     * @method static _IH_Plugin_QB with(array|string $relations)
     * @method _IH_Plugin_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Plugin_C|Plugin[] all()
     * @mixin _IH_Plugin_QB
     */
    class Plugin extends Model {}
    
    /**
     * @property int $id
     * @property string $key
     * @property string $val
     * @property string $type
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Setting_QB onWriteConnection()
     * @method _IH_Setting_QB newQuery()
     * @method static _IH_Setting_QB on(null|string $connection = null)
     * @method static _IH_Setting_QB query()
     * @method static _IH_Setting_QB with(array|string $relations)
     * @method _IH_Setting_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Setting_C|Setting[] all()
     * @mixin _IH_Setting_QB
     */
    class Setting extends Model {}
    
    /**
     * @property int $id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Staff_QB onWriteConnection()
     * @method _IH_Staff_QB newQuery()
     * @method static _IH_Staff_QB on(null|string $connection = null)
     * @method static _IH_Staff_QB query()
     * @method static _IH_Staff_QB with(array|string $relations)
     * @method _IH_Staff_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Staff_C|Staff[] all()
     * @mixin _IH_Staff_QB
     */
    class Staff extends Model {}
    
    /**
     * @property int $id
     * @property string|null $avatar
     * @property string|null $first_name
     * @property string|null $last_name
     * @property string $username
     * @property string|null $gender
     * @property Carbon|null $birthday
     * @property string|null $phone
     * @property string|null $country
     * @property string|null $address
     * @property string $email
     * @property Carbon|null $email_verified_at
     * @property bool $status
     * @property mixed $password
     * @property string|null $remember_token
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read $name attribute
     * @property _IH_Wallet_C|Wallet[] $activeWallets
     * @property-read int $active_wallets_count
     * @method HasMany|_IH_Wallet_QB activeWallets()
     * @property DatabaseNotificationCollection|DatabaseNotification[] $notifications
     * @property-read int $notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB notifications()
     * @property DatabaseNotificationCollection|DatabaseNotification[] $readNotifications
     * @property-read int $read_notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB readNotifications()
     * @property DatabaseNotificationCollection|DatabaseNotification[] $unreadNotifications
     * @property-read int $unread_notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB unreadNotifications()
     * @property _IH_Wallet_C|Wallet[] $wallets
     * @property-read int $wallets_count
     * @method HasMany|_IH_Wallet_QB wallets()
     * @method static _IH_User_QB onWriteConnection()
     * @method _IH_User_QB newQuery()
     * @method static _IH_User_QB on(null|string $connection = null)
     * @method static _IH_User_QB query()
     * @method static _IH_User_QB with(array|string $relations)
     * @method _IH_User_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_User_C|User[] all()
     * @foreignLinks id,\App\Models\Wallet,user_id
     * @mixin _IH_User_QB
     * @method static UserFactory factory(callable|int|mixed[]|null $count = null, callable|mixed[] $state = [])
     */
    class User extends Model {}
    
    /**
     * @property int $id
     * @property int $currency_id
     * @property int $user_id
     * @property string $wallet_id
     * @property float $balance
     * @property bool $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read bool $is_payment attribute
     * @property-read bool $is_receiver attribute
     * @property-read bool $is_sender attribute
     * @property-read bool $is_withdraw attribute
     * @property-read string $name attribute
     * @property Currency $currency
     * @method BelongsTo|_IH_Currency_QB currency()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_Wallet_QB onWriteConnection()
     * @method _IH_Wallet_QB newQuery()
     * @method static _IH_Wallet_QB on(null|string $connection = null)
     * @method static _IH_Wallet_QB query()
     * @method static _IH_Wallet_QB with(array|string $relations)
     * @method _IH_Wallet_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Wallet_C|Wallet[] all()
     * @ownLinks currency_id,\App\Models\Currency,id|user_id,\App\Models\User,id
     * @mixin _IH_Wallet_QB
     */
    class Wallet extends Model {}
}
