<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ __('Invoice') }}</title>
    <style>
        body {
            font-family: 'Arial', sans-serif;
            margin: 0;
            padding: 0;
            background-color: #f4f6f9;
            color: #333;
            line-height: 1.6;
        }

        .invoice-container {
            max-width: 800px;
            margin: 30px auto;
            background: #ffffff;
            border-radius: 10px;
            box-shadow: 0 8px 20px rgba(0, 0, 0, 0.1);
            overflow: hidden;
            padding: 20px;
        }

        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .header .logo {
            font-size: 24px;
            font-weight: bold;
            color: #4a90e2;
        }

        .header .invoice-details {
            text-align: right;
        }

        .invoice-details p {
            margin: 0;
            font-size: 14px;
            color: #555;
        }

        .section {
            margin-top: 20px;
        }

        .section-title {
            font-weight: bold;
            font-size: 16px;
            color: #4a90e2;
            margin-bottom: 10px;
        }

        .info-grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 20px;
        }

        .info-grid div {
            font-size: 14px;
            line-height: 1.4;
        }

        .info-grid div strong {
            display: block;
            font-weight: bold;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
            border-radius: 5px;
        }

        table th, table td {
            padding: 10px;
            text-align: left;
            border: 1px solid #e0e0e0;
        }

        table th {
            background-color: #4a90e2;
            color: #ffffff;
            font-size: 14px;
        }

        table td {
            font-size: 14px;
        }

        .stamp {
            text-align: center;
            margin: 20px 0;
            font-size: 18px;
            text-transform: uppercase;
            font-weight: bold;
            color: #d9534f;
            border: 2px dashed #d9534f;
            border-radius: 5px;
            padding: 10px 20px;
            display: inline-block;
            transform: rotate(-5deg);
        }

        .footer {
            background-color: #4a90e2;
            color: #ffffff;
            padding: 15px 20px;
            margin-top: 30px;
            border-radius: 0 0 10px 10px;
        }

        .footer p {
            margin: 0;
            font-size: 12px;
            text-align: center;
        }
    </style>
</head>
<body>
<div class="invoice-container">
    {{-- Header --}}
    <div class="header">
        <div class="logo">
            <img src="{{ $siteLogo }}" alt="{{ __('Logo') }}" style="height: 50px;">
        </div>
        <div class="invoice-details">
            <p><strong>{{ __('Transaction ID') }}:</strong> {{ $transaction->trx_id }}</p>
            <p><strong>{{ __('Date') }}:</strong> {{ $transaction->created_at->format('d M Y, h:i A') }}</p>
        </div>
    </div>

    {{-- Transaction Info --}}
    <div class="section">
        <div class="section-title">{{ __('Transaction Information') }}</div>
        <div class="info-grid">
            <div>
                <strong>{{ __('Transaction Type') }}:</strong> {{ $transaction->trx_type }}
            </div>
            <div>
                <strong>{{ __('Provider') }}:</strong> {{ $transaction->provider }}
            </div>
            <div>
                <strong>{{ __('Processing Type') }}:</strong> {{ $transaction->processing_type }}
            </div>
            <div>
                <strong>{{ __('Status') }}:</strong> {{ $transaction->status->label() }}
            </div>
        </div>
    </div>

    {{-- Amount Details --}}
    <div class="section">
        <div class="section-title">{{ __('Amount Details') }}</div>
        <table>
            <thead>
            <tr>
                <th>{{ __('Description') }}</th>
                <th>{{ __('Amount') }}</th>
            </tr>
            </thead>
            <tbody>
            <tr>
                <td>{{ __('Transaction Amount') }}</td>
                <td>{{ number_format($transaction->amount, 2) }} {{ $transaction->currency }}</td>
            </tr>
            <tr>
                <td>{{ __('Fee') }}</td>
                <td>{{ number_format($transaction->fee, 2) }} {{ $transaction->currency }}</td>
            </tr>
            <tr>
                <td>{{ __('Net Amount') }}</td>
                <td>{{ number_format($transaction->net_amount, 2) }} {{ $transaction->payable_currency }}</td>
            </tr>
            <tr>
                <td>{{ __('Payable Amount') }}</td>
                <td>{{ number_format($transaction->payable_amount, 2) }} {{ $transaction->payable_currency }}</td>
            </tr>
            </tbody>
        </table>
    </div>

    {{-- Stamp --}}
    @php
        $amountFactor = ($transaction->status === \App\Enums\TrxStatus::COMPLETED) ? 1 : 0.2;
        $displayAmount = number_format($transaction->payable_amount * $amountFactor, 2);
    @endphp
    <div class="stamp"
         style="
         color: {{ $transaction->status->colorCode() }};
         border-color: {{ $transaction->status->colorCode() }};
     ">
        {{ $transaction->status->label() }}<br>
        {{ $displayAmount }} {{ $transaction->payable_currency }}
    </div>

    {{-- Footer --}}
    <div class="footer">
        <p>{{ __('Thank you for your business! | Support: :email', ['email' => setting('support_email')]) }}</p>
    </div>
</div>
</body>
</html>
