@extends('general.merchant.index')
@section('favicon', asset(setting('site_favicon')))
@section('title', __('Secure Wallet Payment - ') . setting('site_title'))
@section('merchant_content')
    <div class="container d-flex justify-content-center py-5">
        <div class="card shadow-sm border-0 rounded-4 p-4">
            {{-- Total Pay Section (Top Position) --}}
            <div class="bg-light p-3 rounded d-flex align-items-center justify-content-between border-dashed mb-4">
                {{-- Icon --}}
                <img src="{{ asset(setting('logo')) }}" alt="{{ setting('site_title') }}"
                     class="img-fluid icon text-primary me-3 fs-3">

                {{-- Payment Amount Details --}}
                <div class="text-end">
                    <small class="text-muted d-block">{{ __('Total Payable Amount') }}</small>
                    <h4 class="fw-bold text-primary m-0">{{ $data['payment_amount'] }}</h4>
                </div>
            </div>


            {{-- Payment Options --}}
            <div class="text-center mb-3">
                <small class="text-muted d-block">
                    {{ __('Pay using your :site_title :wallet_name Wallet ID or log in for a faster checkout.',['site_title' => setting('site_title'),'wallet_name' => $data['currency']]) }}
                </small>
                @auth
                    <form action="{{ route('payment.with.account') }}" method="post" class="d-inline">
                        @csrf
                        <input type="hidden" name="trx_id" value="{{ $trxId }}">

                        <button type="submit" class="text-primary border-0 bg-transparent fw-bold text-decoration-none">
                            <i class="fa-light fa-fingerprint "></i>
                            {{ __('Proceed to Payment') }}
                        </button>
                    </form>
                @else
                    @php
                        $token = Payment::generateToken($trxId);
                    @endphp
                    <a href="{{ route('payment.with.account', ['token' => $token]) }}"
                       class="text-primary fw-bold text-decoration-none">
                        <i class="fa-light fa-fingerprint"></i>
                        {{ __('Login to Pay') }}
                    </a>
                @endauth
            </div>

            {{-- Payment Form --}}
            <form id="paymentForm" action="{{ route('payment.complete') }}" method="post" novalidate>
                @csrf
                <input type="hidden" name="trx_id" value="{{ $trxId }}">

                {{-- Wallet ID Input --}}
                <div class="mb-3">
                    <label for="walletID"
                           class="form-label fw-semibold">{{ __('Enter Your :wallet_name Wallet ID',['wallet_name' => $data['currency']]) }}</label>
                    <div class="input-group shadow-sm rounded">
                        <span class="input-group-text bg-light">
                            <i class="fas fa-wallet text-secondary"></i>
                        </span>
                        <input id="walletID" name="wallet_id" oninput="this.value = validateNumber(this.value)"
                               type="text" class="form-control border-0"
                               placeholder="{{ __('W/ID: 123456789') }}" required>
                    </div>

                </div>

                {{-- Password/PIN Input --}}
                <div class="mb-3">
                    <label for="pinCode" class="form-label fw-semibold">{{ __('Enter Login Password') }}</label>
                    <div class="input-group shadow-sm rounded">
                        <span class="input-group-text bg-light">
                            <i class="fas fa-key text-secondary"></i>
                        </span>
                        <input id="password" name="password" type="password" class="form-control border-0"
                               placeholder="{{ __('Enter your secure password') }}" required>
                        <button type="button" class="btn btn-light border-0" id="togglePassword"
                                aria-label="{{ __('Show/Hide Password') }}">
                            <i class="fas fa-eye"></i>
                        </button>
                    </div>
                </div>

                {{-- Submit Button --}}
                <div class="d-grid mt-4">
                    <button id="payButton" type="submit" class="btn btn-dark fw-bold  rounded-pill" disabled>
                        <i class="fas fa-arrow-right me-2"></i>
                        {{ __('Proceed to Payment') }}
                    </button>
                </div>
            </form>

            {{-- Secure Transaction Notice --}}
            <div class="text-center mt-4 small text-muted">
                <i class="fas fa-lock me-1"></i>
                {{ __('Secure Wallet Payment with 256-bit SSL encryption') }}
            </div>
        </div>
    </div>
@endsection





