@php use App\Enums\MethodType; @endphp
@extends('general.merchant.index')
@section('favicon', asset($data['business_logo']))
@section('title', __('Payment Checkout'))
@section('merchant_content')
    <div class="gateway-section">
        {{-- Compact & Modern Checkout Header --}}
        <div class="checkout-header d-flex align-items-center justify-content-between mb-4 px-4 py-3">
            {{-- Merchant Info --}}
            <div class="d-flex align-items-center gap-3">
                <div class="d-flex align-items-center">
                    <img src="{{ asset($data['business_logo'] ?? 'default-logo.png') }}"
                         alt="{{ $data['business_name'] ?? 'Business' }} Logo"
                         class="merchant-logo">
                </div>
                <div>
                    <h5 class="mb-0">{{ $data['business_name'] }}</h5>
                    <small class="text-muted merchant-description">{{ $data['description'] }}</small>
                </div>
            </div>
            {{-- Payment Amount --}}
            <div class="text-end">
                <small class="text-muted d-block">{{ __('Total Amount') }}</small>
                <h4 class="mb-0 fw-bold">{{ $data['payment_amount'] }}</h4>
            </div>
        </div>


        {{-- Payment Methods Grid --}}
        <section aria-label="{{ __('Payment Methods') }}">
            <h6 class="text-uppercase text-muted mb-3">{{ __('Payment Methods') }}</h6>

            <form id="paymentForm" action="{{ route('payment.process') }}" method="post">
                @csrf
                <input type="hidden" name="selected_method" id="selectedMethod">
                <input type="hidden" name="trx_id" value="{{ $trxId }}">
                <div class="row g-3">
                    <div class="col-6 col-md-3">
                        <div class="payment-logo-card"
                             role="button"
                             tabindex="0"
                             aria-pressed="false"
                             data-method="{{ MethodType::SYSTEM->value }}">
                            <img src="{{ asset(setting('logo')) }}" class="payment-logo"
                                 alt="{{ setting('site_title') }} Logo">
                            <p class="payment-name">{{ setting('site_title') }}</p>
                        </div>
                    </div>

                    @foreach($paymentMethods as $method)
                        <div class="col-6 col-md-3">
                            <div class="payment-logo-card"
                                 role="button"
                                 tabindex="0"
                                 aria-pressed="false"
                                 data-method="{{ $method->method_code }}">
                                <img src="{{ asset($method->logo_alt) }}" class="payment-logo"
                                     alt="{{ $method->name }} Logo">
                                <p class="payment-name">{{ $method->name }}</p>
                            </div>
                        </div>
                    @endforeach
                </div>

                {{-- Payment Action --}}
                <div class="d-grid mt-5">
                    <button id="payButton" type="submit" class="btn btn-primary btn-lg fw-bold" disabled>
                        <i class="fas fa-arrow-right me-2"></i>
                        {{ __('Complete Payment :amount', ['amount' => $data['payment_amount']]) }}
                    </button>
                </div>
            </form>
        </section>


        {{-- Security Footer --}}
        <div class="text-center mt-4 small text-muted">
            <i class="fas fa-lock me-2"></i>
            {{ __('256-bit SSL Secured Payment • PCI DSS Compliant') }}
        </div>
    </div>
@endsection
