<script>
    $(document).ready(function () {
        // Default start and end dates for "Last 30 Days"
        const defaultStart = moment().subtract(29, 'days');
        const defaultEnd = moment();

        // Function to initialize Date Range Picker
        function setupDateRangePicker(selector, start, end, callback) {
            $(selector).daterangepicker({
                startDate: start,
                endDate: end,
                autoUpdateInput: false,
                ranges: {
                    'Today': [moment(), moment()],
                    'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                    'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                    'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                    'This Month': [moment().startOf('month'), moment().endOf('month')],
                    'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
                }
            }, callback);

            // Trigger callback to set initial values
            callback(start, end);
        }

        // Callback to update UI and hidden input field
        function updateDateRangeUI(start, end) {
            const formattedRange =`${start.format('MMM D, YYYY')} - ${end.format(start.isSame(end, 'year') ? 'MMM D' : 'MMM D, YYYY')}`;

            $('#reportrange span').text(formattedRange);
            $('input[name="daterange"]').val(`${start.format('YYYY-MM-DD')},${end.format('YYYY-MM-DD')}`);
        }

        // Retrieve daterange value from Laravel request (if provided)
        const dateRange = '{{ request("daterange") }}';

        // Parse provided daterange or use default values
        const [start, end] = dateRange
            ? dateRange.split(',').map(date => moment(date, 'YYYY-MM-DD'))
            : [defaultStart, defaultEnd];

        // Initialize the Date Range Picker
        setupDateRangePicker('#reportrange', start, end, updateDateRangeUI);

        // Auto-update the input field when a date range is selected
        $('#reportrange').on('apply.daterangepicker', function (ev, picker) {
            updateDateRangeUI(picker.startDate, picker.endDate);
        });
    });
</script>
