@php use App\Enums\MethodType; @endphp
@php use App\Constants\FixPctType; @endphp
@extends('frontend.layouts.user.index')
@section('title', __('My Withdraw Accounts'))
@section('content')
    <div class="single-form-card">
        <div class="card-title mb-0 d-flex flex-wrap justify-content-between align-items-center">
            <h6 class="mb-0 text-white">{{ __('My Accounts') }}</h6>
            <a class="btn btn-light-success btn-sm" href="{{ route('user.withdraw.account.create') }}">
                <i class="fa-solid fa-plus-circle"></i> {{ __('Create Account') }}
            </a>
        </div>
        <div class="card-main bg-main">
            @foreach($withdrawAccounts as $account)
                <div class="withdraw-account-item d-flex align-items-center justify-content-between p-2 rounded mb-2 bg-white border-default">
                    <div class="circle-icon d-flex align-items-center justify-content-center me-2">
                        <img class="img-fluid" src="{{ asset($account->withdrawMethod->logo) }}"
                             alt="{{ __('Withdraw Method Logo') }}">
                    </div>

                    <div class="withdraw-details flex-grow-1">
                        <div class="d-flex flex-column">
                            <span class="fw-bold text-dark">
                                {{ title($account->name) }}
                                @if($account->withdrawMethod->type == MethodType::AUTOMATIC)
                                <span class="badge bg-success ms-1">{{ __('Automatic') }}</span>
                                @else
                                <span class="badge bg-warning ms-1">{{ __('Manual') }}</span>
                                @endif
                            </span>
                            <div class="text-muted small mt-1">
                                {{ __('Fee: ') }}
                                <span class="text-primary">
                                    {{ $account->withdrawMethod->charge }}{{ $account->withdrawMethod->charge_type === FixPctType::PERCENT ? '%' : ' '.$account->withdrawMethod->currency }}
                                </span> |
                                {{ __('Min-Max: ') }} {{ $account->withdrawMethod->min_withdraw }}
                                - {{ $account->withdrawMethod->max_withdraw }} {{ $account->withdrawMethod->currency }}
                            </div>

                        </div>
                    </div>

                    <div>
                        <a href="{{ route('user.withdraw.account.edit', $account->id) }}" class="btn btn-sm btn-primary"
                           aria-label="{{ __('Edit Withdraw Account') }}">
                            <i class="fa-solid fa-pen-to-square"></i>
                            <span class="d-none d-sm-inline">{{ __('Edit') }}</span>
                        </a>

                    </div>
                </div>
            @endforeach

        </div>
    </div>
@endsection
