@extends('frontend.layouts.user.index')
@section('title', __('Edit Withdraw Account'))
@section('content')
    <div class="single-form-card">
        <div class="card-title d-flex flex-column flex-md-row justify-content-between align-items-center">
            <h6 class="text-white mb-2 mb-md-0">{{ __('Edit Withdraw Account') }}</h6>
            <div class="d-flex gap-2">
                <a class="btn btn-light-primary btn-sm" href="{{ route('user.withdraw.account.index') }}">
                    <i class="fa-solid fa-receipt"></i> {{ __('My Accounts') }}
                </a>
            </div>
        </div>
        <div class="card-main">
            <form action="{{ route('user.withdraw.account.update', $withdrawAccount->id) }}" method="POST"
                  enctype="multipart/form-data">
                @csrf
                @method('PUT')

                {{-- Account Name --}}
                <div class="row">
                    <x-form.field
                            type="text"
                            name="account_name"
                            label="{{ __('Account Name') }}"
                            placeholder="{{ __('Enter Account Name') }}"
                            :value="old('name', $withdrawAccount->name)"
                            :colClass="'col-md-6'"
                            :required="true"
                    />

                    @foreach($withdrawAccount->credentials as $field)
                        <x-form.field
                                :type="$field['type']"
                                :name="'credentials['.$field['name'].']'"
                                :label="ucfirst($field['name'])"
                                :placeholder="ucfirst($field['name'])"
                                :value="old('credentials.'.$field['name'], $field['value'] ?? null)"
                                :colClass="'col-md-6 single-input-inner style-border'"
                                :required="$field['validation']"
                        />
                    @endforeach

                </div>


                {{-- Submit Button --}}
                <button type="submit" class="btn btn-primary mt-3 w-100">{{ __('Update Account') }}</button>
            </form>
        </div>
    </div>
@endsection
