@extends('frontend.layouts.user.index')
@section('title', __('Create Withdraw Account'))
@section('content')
    <div class="single-form-card">
        <div class="card-title mb-0 d-flex flex-wrap justify-content-between align-items-center">
            <h6 class="mb-0 text-white">{{ __('Create Account') }}</h6>
            <a class="btn btn-light-primary btn-sm" href="{{ route('user.withdraw.account.index') }}">
                <i class="fa-solid fa-receipt"></i> {{ __('My Accounts') }}
            </a>
        </div>
        <div class="card-main bg-main">
            <form action="{{ route('user.withdraw.account.store') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="row g-3">
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label for="method-select" class="form-label">{{ __('Withdrawal Method') }}</label>
                            <select class="form-select" id="method-select" name="method_id">
                                <option disabled selected>{{ __('Select Withdrawal Method') }}</option>
                                @foreach($withdrawMethods as $method)
                                    <option value="{{ $method->id }}">{{ ucfirst($method->name) }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label for="account-name" class="form-label">{{ __('Account Name') }}</label>
                            <input type="text" class="form-control" id="accountName" name="account_name"
                                   placeholder="{{ __('Enter Account Name') }}" required>
                        </div>
                    </div>
                </div>


                {{-- Dynamic Credential Fields --}}
                <div class="row" id="credential-fields">
                    {{-- Fields will be appended here dynamically --}}
                </div>

                {{-- Submit Button --}}
                <button type="submit" class="btn btn-primary mt-3 w-100">{{ __('Create Account') }}</button>
            </form>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        $(document).ready(function () {
            // Handle withdrawal method selection change
            $('#method-select').on('change', function () {
                let methodId = $(this).val();
                let url = "{{ route('user.withdraw.credentials.fields', ':method_id') }}".replace(':method_id', methodId);

                // Fetch and append credential fields
                $.ajax({
                    url: url,
                    type: 'GET',
                    success: function (data) {
                        $('#credential-fields').html(data.html);
                        $('#accountName').val(data.method_name);
                    },
                    error: function (xhr) {
                        console.error(xhr.responseText);
                    }
                });
            });
        });
    </script>
@endpush
