@php use App\Constants\CurrencyRole; @endphp
<div class="single-card-box image-upload-element-box mb-30">
    <div class="confirm-deposit-box d-flex align-items-center">
        <i class="fas fa-coins me-2"></i>
        <span class="flex-grow-1">{{ __('Type') }}</span>
        <span class="text-uppercase">{{ $currency->type }}</span>
    </div>
    <div class="confirm-deposit-box d-flex align-items-center">
        <i class="fas fa-code me-2"></i>
        <span class="flex-grow-1">{{ __('Code') }}</span>
        <span>{{ $currency->code }}</span>
    </div>
    <div class="confirm-deposit-box d-flex align-items-center">
        <i class="fas fa-exchange-alt me-2"></i>
        <span class="flex-grow-1">{{ __('Rate') }}
            @if($currency->rate_live === true)
                <span class="badge bg-danger">{{ __('LIVE') }}</span>
            @endif
        </span>
        <span>1 {{ siteCurrency() }} = {{ $currency->exchange_rate }} {{ $currency->code }}</span>
    </div>
    <div class="confirm-deposit-box d-flex align-items-center mb-0">
        <i class="fas fa-user-tag me-2"></i>
        <span class="flex-grow-1 me-4">{{ __('Role') }}</span>
        <span>
            @foreach($currency->activeRoles as $role)
                <span class="badge bg-{{ CurrencyRole::getBadgesColor([$role->role_name]) }}">{{ strtoupper($role->role_name) }}</span>
            @endforeach
        </span>
    </div>
</div>

