<div class="modal fade" id="addWalletModal" tabindex="-1" aria-labelledby="addWalletModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h6 class="modal-title" id="addWalletModalLabel">{{ __('Create Wallet') }}</h6>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                @if(!auth()->user()->availableCurrenciesForCreateWallet()->isEmpty())
                    <form action="{{ route('user.wallet.create') }}" method="post">
                        @csrf
                        <div class="mb-3">
                            <label for="currency_id" class="form-label">{{ __('Select Currency') }}</label>
                            <select name="currency_id" id="currency_id" class="form-select" required>
                                <option value="" selected disabled>{{ __('Select Currency') }}</option>
                                @foreach(auth()->user()->availableCurrenciesForCreateWallet() as $currency)
                                    <option value="{{ $currency->id }}">{{ $currency->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="currency-preview"></div>

                        <div class="d-flex justify-content-between">
                            <button type="button" class="btn btn-default btn-secondary" data-bs-dismiss="modal">
                                <x-icon name="x" height="20" width="20"/> {{ __('Close') }}</button>
                            <button type="submit" class="btn btn-base btn-default">
                                <x-icon name="check" height="20" width="20"/> {{ __('Create Wallet') }}</button>
                        </div>
                    </form>
                @else
                    <div class="alert alert-danger">
                        <p class="mb-0">{{ __('You don\'t have any currency to create a wallet.') }}</p>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>
@push('scripts')
    <script>
        $(document).ready(function () {
            'use strict';
            $('#currency_id').on('change', function () {
                const currencyId = $(this).val();
                const url = `{{ route('user.wallet.currency-info', ['currency_id' => ':currency_id']) }}`.replace(':currency_id', currencyId);

                $('.currency-preview').html('<div class="d-flex align-items-center justify-content-center"><div class="spinner-border text-primary" role="status"><span class="visually-hidden">@lang('Loading...')</span></div></div>');
                $.get(url, function (data) {
                    $('.currency-preview').html(data);
                });
            });
        });
    </script>
@endpush
