@php use App\Constants\CurrencyRole; @endphp
@extends('frontend.layouts.user.index')
@section('title', __('All Wallet'))
@section('content')
    <div class="row">
        <div class="col-12">
            <div class="card single-form-card">
                <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center">
                    <h6 class="mb-0 text-white">{{ __('All Wallet') }}</h6>
                    <button type="button" class="btn btn-light btn-sm d-flex align-items-center" data-bs-toggle="modal"
                            data-bs-target="#addWalletModal">
                        <x-icon name="wallet" height="20" width="20" class="me-1"/>
                        {{ __('Create Wallet') }}
                    </button>
                </div>
                <div class="card-body">
                    <div class="wallet-grid">
                        @foreach($wallets as $wallet)
                            @php
                                $amountColor = $wallet->latestTransaction?->amount_flow->color($wallet->latestTransaction->status);
                                $amountSign = $wallet->latestTransaction?->amount_flow->sign($wallet->latestTransaction->status);
                            @endphp

                            <div class="wallet-card">
                                {{-- Header Section: Currency Info and Balance --}}
                                <div class="wallet-header">
                                    {{-- Currency Info --}}
                                    <div class="wallet-currency-info">
                                        <img src="{{ asset($wallet->currency->flag) }}" class="wallet-currency-img"
                                             alt="{{ $wallet->currency->code }}">
                                        <div class="ms-3">
                                            <h6 class="fw-bold mb-0">{{ $wallet->currency->code }}  @if( $wallet->currency->code == siteCurrency() )
                                                    <span class="text-success">({{ __('Default') }})</span>
                                                @endif </h6>
                                            <p class="text-muted small mb-0">{{ __('W\ID:') }} {{ implode(' ', str_split($wallet->uuid, 3)) }}</p>
                                        </div>
                                    </div>

                                    {{-- Balance --}}
                                    <div class="text-end">
                                        <h5 class="wallet-balance mb-0">{{ $wallet->currency->symbol }}{{ number_format($wallet->balance, 2) }}</h5>
                                        <p class="text-muted small mb-0">
                                            1 {{ siteCurrency() }}
                                            = {{ $wallet->currency->exchange_rate }} {{ $wallet->currency->code }}
                                        </p>
                                    </div>
                                </div>

                                {{-- Divider --}}
                                <div class="wallet-divider my-3"></div>

                                {{-- Wallet Roles --}}
                                <div class="wallet-roles mb-2">
                                    @foreach($wallet->currency->activeRoles as $role)
                                        <div class="wallet-role-icon bg-{{ CurrencyRole::getBadgesColor($role->role_name) }}"
                                             title="{{ strtoupper($role->role_name) }}" data-bs-toggle="tooltip">
                                            <x-icon name="{{ str_replace('_', '-', $role->role_name) }}" height="20"
                                                    width="20"/>
                                        </div>
                                    @endforeach

                                </div>

                                {{-- Footer Section: Latest Transaction and Actions --}}
                                <div class="wallet-footer">
                                    {{-- Latest Transaction --}}
                                    <div class="wallet-transaction-info me-2">
                                        @if($wallet->latestTransaction)
                                            <p class="small mb-0">
                                                <span class="text-muted">{{ __('Recent:') }}</span>
                                                <span class="fw-bold {{ $amountColor }}">
                                                    {{ $amountSign.getSymbol($wallet->currency->code).number_format($wallet->latestTransaction->amount, 2) }}
                                                </span>
                                                <span class="text-muted">{{ __('via') }}</span>
                                                <span class="fw-bold text-{{ $wallet->latestTransaction->trx_type->badgeColor() }}">
                                                    {{ $wallet->latestTransaction->trx_type->label() }}
                                                </span>
                                            </p>
                                        @else
                                            <p class="small mb-0 text-muted">{{ __('No recent activity.') }}</p>
                                        @endif
                                    </div>

                                    {{-- Actions --}}
                                    <div class="d-flex gap-2">
                                        <a href="{{ route('user.deposit.create', ['uuid' => $wallet->uuid]) }}" class="wallet-btn-icon" title="{{ __('Deposit') }}"
                                           data-bs-toggle="tooltip">
                                            <x-icon name="deposit" height="20" width="20"/>
                                        </a>
                                        @if($wallet->is_withdraw)
                                            <a href="{{ route('user.withdraw.create', ['uuid' => $wallet->uuid]) }}" class="wallet-btn-icon" title="{{ __('Withdraw') }}"
                                               data-bs-toggle="tooltip">
                                                <x-icon name="withdraw" height="20" width="20"/>
                                            </a>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection






























