<div class="modal fade" id="redeemVoucherModal" tabindex="-1" aria-labelledby="redeemVoucherModalLabel"
     aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-md">
        <div class="modal-content shadow-lg">
            {{-- Header --}}
            <div class="modal-header bg-light border-0">
                <h5 class="modal-title text-primary fw-bold" id="redeemVoucherModalLabel">
                    <i class="fa-solid fa-receipt me-2"></i> {{ __('Redeem Voucher') }}
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            {{-- Form --}}
            <form id="redeemVoucherForm" method="POST" action="{{ route('user.voucher.redeem') }}">
                @csrf
                <div class="modal-body p-4">
                    {{-- Voucher Input --}}
                    <div class="mb-3 position-relative">
                        <label for="voucherCode" class="form-label fw-semibold">{{ __('Voucher Code') }}</label>
                        <div class="input-group">
                            <span class="input-group-text bg-primary text-white" id="voucher-addon">
                                <i class="fa-solid fa-ticket-alt"></i>
                            </span>
                            <input
                                    type="text"
                                    class="form-control"
                                    id="voucherCode"
                                    name="voucher_code"
                                    placeholder="VCR-XXXXXXX"
                                    aria-describedby="voucher-addon"
                                    required
                                    pattern="^VCR-[A-Z0-9]{8}$"
                                    title="Code must follow the format VCR-XXXXXXX.">
                        </div>
                        <div class="form-text mt-1">
                            <i class="fa-solid fa-info-circle"></i> {{ __('Code must start with VCR- followed by 8 letters or digits.') }}
                        </div>
                    </div>
                </div>
                {{-- Footer --}}
                <div class="modal-footer border-0 d-flex justify-content-between">
                    <button type="button" class="btn btn-light-danger" data-bs-dismiss="modal">
                        <i class="fa-solid fa-xmark me-1"></i> {{ __('Close') }}
                    </button>
                    <button type="submit" class="btn btn-primary">
                        <i class="fa-solid fa-check me-1"></i> {{ __('Redeem') }}
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
