@extends('frontend.layouts.user.index')
@section('title', __('My Vouchers'))
@section('content')

    <div class="single-form-card">
        <div class="card-title d-flex flex-column flex-md-row justify-content-between">
            <h6 class="text-white mb-2 mb-md-0">{{ __('My Vouchers') }}</h6>
            <div class="d-flex gap-2 flex-row">
                <a class="btn btn-light-success btn-sm" href="{{ route('user.voucher.create') }}">
                    <i class="fa-solid fa-plus-circle"></i> {{ __('Generate Voucher') }}
                </a>
                <a class="btn btn-light-primary btn-sm" href="#" data-bs-toggle="modal"
                   data-bs-target="#redeemVoucherModal">
                    <i class="fa-solid fa-receipt"></i> {{ __('Redeem Voucher') }}
                </a>
            </div>
        </div>
        <div class="card-main">
            <div class="history-table">
                <div class="table-list">
                    <ul class="list-header">
                        <li>{{ __('Voucher Code') }}</li>
                        <li>{{ __('Amount') }}</li>
                        <li>{{ __('For Wallet') }}</li>
                        <li>{{ __('Status') }}</li>
                        <li>{{ __('Redeemed On') }}</li>
                        <li>{{ __('Created On') }}</li>
                    </ul>
                </div>
                <div class="table-list">
                    @forelse($vouchers as $voucher)
                        <ul class="list-content">
                            <li class="">
                                <span class="voucher-code">{{ $voucher->code }}</span>
                                <span class="copy-wrapper">
                                   <i class="fa-solid fa-copy text-primary cursor-pointer copy-icon copyNow"
                                      data-clipboard-text="{{ $voucher->code }}"
                                      title="{{ __('Copy Voucher Code') }}"
                                      data-bs-toggle="tooltip"
                                      data-bs-placement="top"></i>

                                </span>
                            </li>
                            <li>{{ $voucher->currency->symbol . number_format($voucher->amount, 2)  }}</li>
                            <li class="text-uppercase">{{ $voucher->currency->code ?? __('N/A') }}</li>
                            <li>
                                @if($voucher->is_active && is_null($voucher->redeemed_at))
                                    <span class="badge bg-success text-white">{{ __('Available') }}</span>
                                @else
                                    <span class="badge bg-danger text-white">{{ __('Redeemed') }}</span>
                                @endif
                            </li>
                            <li>{{ $voucher->redeemed_at ? $voucher->redeemed_at->format('M d Y') : __('N/A') }}</li>
                            <li>{{ $voucher->created_at->format('M d Y') }}</li>
                        </ul>
                    @empty
                        <ul class="list-content">
                            <li colspan="5" class="text-center">{{ __('No vouchers found.') }}</li>
                        </ul>
                    @endforelse
                </div>
            </div>
        </div>
    </div>

    {{-- redeem voucher modal--}}
    @include('frontend.user.vouchers.partials._redeem_voucher_modal')

@endsection
