@php use App\Constants\CurrencyRole; @endphp
@extends('frontend.layouts.user.index')
@section('title', __('Create Voucher'))
@section('content')
    <div class="row">
        <div class="col-lg-7">
            <div class="single-form-card">
                <div class="card-title mb-0 d-flex flex-column flex-md-row justify-content-between">
                    <h6 class="text-white mb-2 mb-md-0">{{ __('Create Voucher') }}</h6>
                    <div class="d-flex gap-2 flex-row ">
                        <a class="btn btn-light-success btn-sm" href="{{ route('user.voucher.my') }}">
                            <i class="fas fa-list"></i> {{ __('My Vouchers') }}
                        </a>
                    </div>
                </div>
                <div class="card-main">
                    <form action="{{ route('user.voucher.store') }}" method="post">
                        @csrf
                        <div class="single-select-inner style-border">
                            <label>{{ __('Select Wallet for Voucher') }}</label>
                            <select class="form-select single-select wallet-select" name="wallet_id">
                                <option disabled selected>{{ __('Choose a Wallet') }}</option>
                                @foreach($wallets as $wallet)
                                    <option value="{{ $wallet->id }}">{{ __(':name Wallet', ['name' => $wallet->name]) }}</option>
                                @endforeach
                            </select>
                            <span class="small color-base fw-500 span-consistent wallet-info"></span>
                        </div>
                        <div class="single-input-inner style-border mb-0 mt-3">
                            <label class="form-label">{{ __('Voucher Amount') }}</label>
                            <div class="input-group input-group-right">
                                <input type="text" class="form-control amount-input" name="amount"
                                       oninput="this.value = validateDouble(this.value)"
                                       placeholder="{{ __('Enter Voucher Amount') }}">
                                <span class="input-group-text input-group-text-right">{{ siteCurrency() }}</span>
                            </div>
                            <span class="small color-base fw-500 voucher-amount-info span-consistent"></span>
                        </div>
                        <button type="submit" class="btn btn-base w-100 mt-4 submit-btn">
                            <x-icon name="check" height="20"/>
                            {{ __('Create Voucher') }}
                        </button>
                    </form>
                </div>
            </div>
        </div>
        <div class="col-lg-5">
            <div class="single-form-card">
                <div class="card-title mb-0 d-flex flex-column flex-md-row justify-content-between">
                    <h6 class="text-white mt-2">{{ __('Voucher Summary') }}</h6>
                </div>
                <div class="card-main">
                    <ul class="summery-list list-unstyled">
                        <li class="d-flex justify-content-between">
                            <span>{{ __('Voucher Amount') }}</span>
                            <span class="summary-amount"></span>
                        </li>
                        <li class="d-flex justify-content-between">
                            <span>{{ __('Voucher Fee') }}</span>
                            <span class="summary-charge"></span>
                        </li>
                        <li class="d-flex justify-content-between">
                            <strong>{{ __('Total Amount') }}</strong>
                            <strong class="summary-total"></strong>
                        </li>
                        <li class="d-flex justify-content-between text-primary">
                            <strong>{{ __('Conversion Rate') }}</strong>
                            <strong class="summary-rate"></strong>
                        </li>
                        <li class="d-flex justify-content-between">
                            <strong>{{ __('Final Voucher Value') }}</strong>
                            <strong class="summary-voucher-value"></strong> {{-- Updated class --}}
                        </li>
                        <li class="d-flex justify-content-between">
                            <strong>{{ __('Payable Amount') }}</strong>
                            <strong class="summary-payable-value"></strong>
                        </li>
                    </ul>
                </div>
            </div>
        </div>

    </div>
@endsection
@push('scripts')
    <script>
        'use strict';

        let voucherInfo = {};
        let voucherInputValues = {
            walletId: null,
            amount: 0,
        };

        const voucherSelectors = {
            walletSelect: '.wallet-select',
            walletInfo: '.wallet-info',
            amountInfo: '.voucher-amount-info',
            summaryAmount: '.summary-amount',
            summaryCharge: '.summary-charge',
            summaryTotal: '.summary-total',
            summaryRate: '.summary-rate',
            voucherValue: '.summary-voucher-value',
            payableValue: '.summary-payable-value',
        };

        // Reset data when wallet changes
        const resetVoucherData = () => {
            voucherInfo = {};
            voucherInputValues.walletId = null;
            $(voucherSelectors.walletSelect).html('<option disabled selected>{{ __("Choose a Wallet") }}</option>');
            $(voucherSelectors.walletInfo).text('');
            updateVoucherSummary();
        };

        // Update the voucher summary
        const updateVoucherSummary = () => {

            const {amount} = voucherInputValues;
            const {fee, fee_type, currency_rate, wallet_currency, min_limit, max_limit} = voucherInfo;
            if (!currency_rate || !wallet_currency || !amount) return;
            if (amount < min_limit || amount > max_limit) {
                $(voucherSelectors.amountInfo)
                    .text(`{{ __("Amount must be between") }} ${min_limit} {{ siteCurrency() }} {{ __("and") }} ${max_limit} {{ siteCurrency() }}`)
                    .addClass('text-danger').removeClass('text-success');
                return;
            } else {
                $(voucherSelectors.amountInfo)
                    .text(`Min: ${min_limit} {{ siteCurrency() }} | Max: ${max_limit} {{ siteCurrency() }}`)
                    .removeClass('text-danger');
            }

            const feeAmount = fee_type === 'fixed' ? parseFloat(fee) : (parseFloat(fee) / 100) * amount;
            const total = parseFloat(amount) + feeAmount;
            const voucherValue = (amount * currency_rate).toFixed(2);
            const convertedAmount = (total * currency_rate).toFixed(2);

            console.log(total, convertedAmount);

            // Update summary UI
            $(voucherSelectors.summaryAmount).text(`${amount.toFixed(2)} {{ siteCurrency() }}`);
            $(voucherSelectors.summaryCharge).text(`${feeAmount.toFixed(2)} {{ siteCurrency() }}`);
            $(voucherSelectors.summaryTotal).text(`${total.toFixed(2)} {{ siteCurrency() }}`);
            $(voucherSelectors.summaryRate).text(`1 {{ siteCurrency() }} = ${currency_rate} ${wallet_currency}`);
            $(voucherSelectors.voucherValue).text(`${voucherValue} ${wallet_currency}`);
            $(voucherSelectors.payableValue).text(`${convertedAmount} ${wallet_currency}`);
        };

        // Fetch wallet information
        const fetchVoucherWalletInfo = () => {
            if (!voucherInputValues.walletId) return;

            const url = "{{ route('user.wallet.info', [CurrencyRole::VOUCHER, ':walletId']) }}"
                .replace(':walletId', voucherInputValues.walletId);

            $.get(url, (data) => {
                voucherInfo = {...data.data};
                updateWalletFee(data.data);
                updateVoucherSummary();
            });
        };

        const updateWalletFee = (walletData) => {
            const feeText = walletData.fee_type === 'fixed'
                ? `${walletData.fee} {{ siteCurrency() }}`
                : `${walletData.fee}%`;


            $(voucherSelectors.walletInfo).text(`{{ __('Fee') }}: ${feeText}`);
            $(voucherSelectors.amountInfo).text(`Min: ${walletData.min_limit} {{ siteCurrency() }} | Max: ${walletData.max_limit} {{ siteCurrency() }}`);
        };

        // Event listeners
        $(document)
            .on('change', voucherSelectors.walletSelect, function () {
                voucherInputValues.walletId = $(this).val();
                fetchVoucherWalletInfo();
            })
            .on('keyup', '.amount-input', function () {
                voucherInputValues.amount = parseFloat($(this).val()) || 0;
                updateVoucherSummary();
            });

    </script>

@endpush
