@php use App\Enums\TrxType; @endphp
@php use App\Enums\TrxStatus; @endphp
<div class="modal fade" id="transactionModal{{ $transaction->id }}">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header border-0 justify-content-center">
                <div class="type-icon d-flex align-items-center justify-content-center {{ $transactionTypeClass }}">
                    <x-icon name="{{ $transactionTypeClass }}" height="40" width="40"/>
                </div>
                <button type="button" class="btn-close position-absolute top-0 end-0 m-3" data-bs-dismiss="modal" aria-label="Close"></button>

            </div>
            <div class="modal-body text-center pt-0">
                <h5 class="receipt-title mb-0">{{ __('Transaction Details') }}</h5>
                <span class="small text-muted"> {{ $transaction->created_at->format('d M Y, h:i A') }} </span>
                <p class="receipt-subtitle">{{ $transaction->description }}</p>
                <hr class="divider my-3">
                <div class="trx-details">
                    <div>
                        <strong>{{ __('Transaction ID') }}</strong>
                        <span>{{ $transaction->trx_id }}</span>
                    </div>
                    <div>
                        <strong>{{ __('Transaction Type') }}</strong>
                        <span class="bg-transparent {{ $transactionTypeClass }}">{{ $transaction->trx_type->label() }}</span>
                    </div>
                    <div>
                        <strong>{{ __('Provider') }}</strong>
                        <span>{{ $transaction->provider }}</span>
                    </div>
                    <div>
                        <strong>{{ __('Amount') }}</strong>
                        <span>{{ number_format($transaction->amount, 2) }} {{ $transaction->currency }}</span>
                    </div>
                    <div>
                        <strong>{{ __('Fee') }}</strong>
                        <span>{{ number_format($transaction->fee, 2) }} {{ $transaction->currency }}</span>
                    </div>
                    <div>
                        <strong>{{ __('Net Amount') }}</strong>
                        <span>{{ number_format($transaction->net_amount, 2) }} {{ $transaction->payable_currency }}</span>
                    </div>
                    <div>
                        <strong>{{ __('Payable Amount') }}</strong>
                        <span>{{ number_format($transaction->payable_amount, 2) }} {{ $transaction->payable_currency }}</span>
                    </div>
                    <div>
                        <strong>{{ __('Status') }}</strong>
                        <span>
                            <span class="badge text-white bg-{{ $transaction->status->color() }} small">{{ $transaction->status->label() }}</span>
                        </span>
                    </div>
                    <div class="full-width">
                        <strong>{{ __('Note') }}</strong>
                        <span class="text-capitalize">{{ ucwords($transaction->remarks ?? 'N/A') }}</span>
                    </div>
                </div>

                @if( $transaction->trx_type == TrxType::REQUEST_MONEY && $transaction->status === TrxStatus::PENDING &&  $transaction->trx_reference !== null)
                    <form method="POST" action="{{ route('user.transaction.action') }}">
                        @csrf
                        <input type="hidden" name="trx_id" value="{{ $transaction->trx_id }}">
                        <input type="hidden" name="action" id="action">

                        <div class="trx-action mt-2">
                            <strong class="text-start">{{ __('Remarks (Optional)') }}</strong>
                            <textarea name="remarks" rows="3" class="form-control w-100"></textarea>
                            <div class="d-flex justify-content-between gap-2 mt-2">
                                <button type="button" class="btn btn-light-success w-50"
                                        onclick="document.getElementById('action').value='approve'; this.form.submit();">
                                    {{ __('Approved') }}
                                </button>
                                <button type="button" class="btn btn-light-danger w-50"
                                        onclick="document.getElementById('action').value='reject'; this.form.submit();">
                                    {{ __('Rejected') }}
                                </button>
                            </div>
                        </div>
                    </form>

                @endif
                <div class="receipt-bottom mt-4 d-flex justify-content-center gap-2">
                    <a href="{{ route('user.transaction.download-pdf', $transaction->trx_id) }}"
                       class="btn btn-light-primary ">
                        <i class="fa-solid fa-file-lines"></i> {{ __('PDF Download') }}
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
