@php use App\Enums\TrxType; @endphp
@php use App\Enums\TrxStatus; @endphp
@extends('frontend.layouts.user.index')
@section('title', __('Transactions'))
@section('content')
    <div class="row">
        <div class="col-12">
            <div class="card single-form-card">
                {{-- Card Header --}}
                <div class="card-title mb-0">
                    <h6 class="mb-0 text-white">{{ __('Transactions') }}</h6>
                    {{-- Toggle Button: Visible only on small devices --}}
                    <div class="d-md-none">
                        <button class="btn btn-light-primary d-flex align-items-center" type="button"
                                data-bs-toggle="collapse" data-bs-target="#filterSection" aria-expanded="false"
                                aria-controls="filterSection">
                            <i class="fa-solid fa-filter me-2"></i> {{ __('Filters') }}
                        </button>
                    </div>
                </div>

                {{-- Card Body --}}
                <div class="card-body">
                    {{-- Filter Section --}}
                    <div class="collapse d-md-block" id="filterSection">
                        <div class="single-form-card card card-body">
                            <form action="{{ route('user.transaction.index') }}" method="GET"
                                  class="row gy-3 align-items-end">
                                {{-- Date Range --}}
                                <div class="col-md-auto">
                                    <label for="reportrange" class="form-label small">{{ __('Date Range') }}</label>
                                    <div class="input-group">
                                        <input type="hidden" name="daterange" value="">
                                        <div id="reportrange" class="form-control rounded d-flex align-items-center"
                                             role="button" tabindex="0" aria-label="{{ __('Select date range') }}">
                                            <i class="fa-solid fa-calendar-days me-2"></i>
                                            <span class="flex-grow-1"></span>
                                            <i class="fa-solid fa-angle-down ms-2"></i>
                                        </div>
                                    </div>
                                </div>

                                {{-- Transaction Type --}}
                                <div class="col-md-auto">
                                    <x-form.select name="type" label="{{ __('Transaction Type') }}"
                                                   :options="TrxType::options()"
                                                   :selected="request('type')"/>
                                </div>

                                {{-- Transaction Status --}}
                                <div class="col-md-auto">
                                    <x-form.select name="status" label="{{ __('Transaction Status') }}"
                                                   :options="TrxStatus::options()"
                                                   :selected="request('status')"/>
                                </div>

                                {{-- Search --}}
                                <div class="col-md">
                                    <label for="search" class="form-label small">{{ __('Search') }}</label>
                                    <div class="input-group">
                                        <input
                                                type="text"
                                                name="search"
                                                id="search"
                                                value="{{ request('search') }}"
                                                class="form-control"
                                                placeholder="{{ __('Search...') }}"
                                                aria-label="{{ __('Search') }}"
                                        >
                                        <button type="submit" class="btn btn-primary">
                                            <i class="fa-solid fa-magnifying-glass"></i>
                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>

                    {{-- Transactions List --}}
                    <div class="transaction-list mt-4">
                        @forelse($transactions as $transaction)
                            @php
                                $transactionTypeClass = $transaction->trx_type->kebabCase();
                                $icon = $transaction->trx_type->icon();
                                $amountColor = $transaction->amount_flow->color($transaction->status);
                                $amountSign = $transaction->amount_flow->sign($transaction->status);
                            @endphp
                            <div class="transaction-item d-flex align-items-center p-2 rounded mb-2" role="button"
                                 data-bs-toggle="modal" data-bs-target="#transactionModal{{ $transaction->id }}">
                                {{-- Icon --}}
                                <div class="transaction-icon rounded d-flex align-items-center justify-content-center me-3 {{ $transactionTypeClass }}">
                                    <x-icon name="{{ $icon }}" height="25" width="25"/>
                                </div>
                                {{-- Details --}}
                                <div class="transaction-details flex-grow-1">
                                    <div class="d-flex justify-content-between align-items-start">
                                        <div>
                                            <span class="fw-bold text-dark">{{ $transaction->description }}</span>
                                            <div class="small fw-bold mt-1  text-uppercase bg-transparent {{ $transactionTypeClass }}">
                                                {{ title($transaction->trx_type->value) }}
                                            </div>
                                            <div class="text-muted small mt-1">
                                                {{ __('TRX') }}: {{ strtoupper($transaction->trx_id) }}
                                            </div>
                                        </div>
                                        <div class="text-end">
                                            <span class="fw-bold d-block {{ $amountColor }}">{{ $amountSign . number_format($transaction->amount, 2) }} {{ $transaction->currency }}</span>
                                            <span class="badge bg-{{ $transaction->status->color() }} mt-1 small px-2 py-1">{{ strtoupper($transaction->status->value) }}</span>
                                            <div class="text-muted small mt-1">
                                                {{ $transaction->created_at->format('d M Y, h:i A') }}
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            {{-- Transaction Modal --}}
                            @include('frontend.user.transaction.partials._details_modal', ['transaction' => $transaction, 'transactionTypeClass' => $transactionTypeClass])
                        @empty
                            <div class="text-center text-muted">{{ __('No transactions found') }}</div>
                        @endforelse
                    </div>

                    {{-- Pagination --}}
                    @if($transactions->hasPages())
                        <div class="mt-3 d-flex justify-content-center">
                            {{ $transactions->links() }}
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection

