@extends('frontend.layouts.user.index')
@section('title', __('Support Ticket Details'))
@section('content')
    <div class="card single-form-card">
        <div class="card-title d-flex flex-column flex-md-row justify-content-between">
            <h6 class="text-white mb-2 mb-md-0"> {{ __('Ticket Details') }}</h6>
            <div class="d-flex gap-2 flex-row">
                <a class="btn btn-light-primary btn-sm" href="{{ route('user.support-ticket.index') }}">
                    <i class="fa-solid fa-ticket-alt"></i> {{ __('My Ticket ') }}
                </a>
            </div>
        </div>

        <div class="card-body">
            <div class="p-3 rounded bg-light">
                <div class="d-flex flex-column flex-md-row align-items-start align-items-md-center justify-content-between ">
                    <div class="d-flex align-items-center gap-2">
                        <h6 class="mb-0 text-truncate">{{ __('Ticket ID: :id', ['id' => $ticket->uuid]) }}</h6>
                        <span class="badge bg-{{ $ticket->priority->badgeColor() }} text-uppercase">{{ $ticket->priority->label() }}</span>
                    </div>
                    <span class="badge bg-{{ $ticket->status->badgeColor() }} text-uppercase">{{ $ticket->status->label()   }}</span>
                </div>

                {{-- Ticket Details --}}
                <div class="mt-3">
                    <h6 class="fw-bold text-primary mb-1">{{ $ticket->title }}</h6>
                    <p class="text-muted mb-0">{!! nl2br(e($ticket->message)) !!}</p>
                </div>
            </div>

            {{-- Chat Section --}}
            @if($ticket->messages->count() > 0)
                <div class="px-3 py-3 overflow-auto" id="chat-box">
                    @foreach($ticket->messages as $message)
                        <div class="d-flex {{ $message->admin_id ? 'justify-content-start' : 'justify-content-end' }} mb-3">
                            @if($message->admin_id)
                                <img src="{{ asset(auth()->user()->avatar_alt) }}"
                                     class="rounded-circle me-2" alt="Admin" width="40" height="40">
                            @endif
                            <div class="{{ $message->admin_id ? 'bg-light' : 'bg-primary' }} p-3 rounded-3">
                                <p class="mb-2 {{ $message->admin_id ? 'text-muted' : 'text-white' }}">{!! nl2br(e($message->message)) !!}</p>
                                @if($message->attachment)
                                    <a href="{{ route('file.download', ['filePath' => $message->attachment]) }}"
                                       class="d-block mt-2 text-warning text-decoration-none">
                                        <i class="fas fa-download"></i> {{ __('Download Attachment') }}
                                    </a>
                                @endif
                                <small class="d-block mt-2 {{ $message->admin_id ? 'text-muted' : 'text-white' }}">
                                    <i class="fas fa-user"></i> {{ $message->admin_id ? 'Admin' : $ticket->user->name }}
                                    |
                                    <i class="fas fa-clock"></i> {{ $message->created_at->format('g:i A') }}
                                </small>
                            </div>
                            @if(!$message->admin_id)
                                <img src="{{ asset($ticket->user->avatar_alt) }}"
                                     class="rounded-circle ms-2" alt="User" width="40" height="40">
                            @endif
                        </div>
                    @endforeach
                </div>
            @endif

            {{-- Chat Input --}}
            <div class="bg-light p-3 p-md-4 rounded  custom-ticket-form">
                <form action="{{ route('user.support-ticket.reply', $ticket->id) }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    
                    {{-- Message --}}
                    <div class="mb-3">
                        <textarea name="message" class="form-control" rows="4"
                      placeholder="{{ __('Type your message here...') }}" required></textarea>
                    </div>
                    
                    {{-- File Preview --}}
                    <div class="mb-3 d-none " id="attachment-preview">
                        <div class="file-preview d-flex justify-content-between align-items-center px-3 py-2 border bg-white">
                            <div class="d-flex align-items-center text-muted">
                                <i class="fas fa-file me-2 text-primary"></i>
                                <span id="file-name" class="small text-truncate"></span>
                            </div>
                            <button type="button" class="remove-btn" onclick="removeFile()">
                                {{ __('Remove') }}
                            </button>

                        </div>
                    </div>
                    
                    {{-- Action Buttons --}}
                    <div class="d-flex flex-wrap justify-content-between gap-2">
                        {{-- Attach --}}
                        <div class="button-wrap">
                            <input type="file" id="file-input" name="attachment" class="d-none" onchange="handleFileChange()">
                            <label for="file-input" class="btn btn-border-base  d-inline-flex align-items-center justify-content-center w-100">
                                <i class="fas fa-paperclip me-2"></i> {{ __('Attach') }}
                            </label>
                        </div>
                        
                        {{-- Send Now --}}
                        <div class="button-wrap">
                            <button type="submit" class="btn btn-primary d-inline-flex align-items-center justify-content-center w-100">
                                <i class="fas fa-paper-plane me-2"></i> {{ __('Send Now') }}
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        
        
        </div>
    </div>
@endsection

@push('scripts')
    @include('frontend.user.support_ticket.partials._script')
@endpush







