@extends('frontend.layouts.user.index')
@section('title', __('New Support Ticket'))
@section('content')

    <div class="card single-form-card">
        <div class="card-title d-flex flex-column flex-md-row justify-content-between">
            <h6 class="text-white mb-2 mb-md-0">{{ __('New Support Ticket') }}</h6>
            <div class="d-flex gap-2 flex-row">
                <a class="btn btn-light-primary btn-sm" href="{{ route('user.support-ticket.index') }}">
                    <i class="fa-solid fa-ticket-alt"></i>  {{ __('My Ticket') }}
                </a>
            </div>
        </div>

        {{-- Card Body --}}
        <div class="card-body">
            <div class="card-body">
                <form action="{{ route('user.support-ticket.store') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="row g-3">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="title" class="form-label">{{ __('Ticket Title') }}</label>
                                <input type="text"
                                       class="form-control @error('title') is-invalid @enderror"
                                       id="title"
                                       name="title"
                                       value="{{ old('title') }}"
                                       required>
                                @error('title')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="category_id" class="form-label">{{ __('Category (Optional)') }}</label>
                                <select class="form-select"
                                        id="category_id"
                                        name="category_id">
                                    <option value="">{{ __('Select Category') }}</option>
                                    @foreach($categories as $category)
                                        <option value="{{ $category->id }}"
                                                {{ old('category_id') == $category->id ? 'selected' : '' }}>
                                            {{ ucfirst($category->name) }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label for="message" class="form-label">{{ __('Message') }}</label>
                        <textarea class="form-control @error('message') is-invalid @enderror h-25"
                                  id="message"
                                  name="message"
                                  required>{{ old('message') }}</textarea>
                        @error('message')
                        <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="row g-3">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="attachments" class="form-label">{{ __('Attach Files (Optional)') }}</label>
                                <input type="file"
                                       class="form-control @error('attachments') is-invalid @enderror"
                                       id="attachments"
                                       name="attachment"
                                       multiple>
                                @error('attachments')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="priority" class="form-label">{{ __('Priority') }}</label>
                                <select class="form-select @error('priority') is-invalid @enderror" id="priority" name="priority" required>
                                    @foreach(\App\Enums\TicketPriority::options() as $priority)
                                        <option value="{{ $priority['value'] }}" {{ old('priority') == $priority['value'] ? 'selected' : '' }}>
                                            {{ $priority['label'] }}
                                        </option>
                                    @endforeach
                                
                                </select>
                                @error('priority')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="mt-3">
                        <div class="d-flex justify-content-end">
                            <button type="submit" class="btn btn-primary">
                                <x-icon name="message-share" /> {{ __('Submit Support Ticket') }}
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>


@endsection



