@extends('frontend.user.setting.index')
@section('title', __('Settings'))
@section('user_setting_content')
    @if($user->email_verified_at == null)
        <div class="alert alert-danger m-2">
            <i class="fas fa-exclamation-triangle me-2"></i>
            {{ __('Please verify your email') }} — <a href="{{ route('user.settings.verify-email') }}" class="alert-link text-success">{{ __('Verify Now') }}
                !</a>
        </div>
    @endif

    <form action="{{ route('user.settings.profile.update') }}" method="post" enctype="multipart/form-data">
        @csrf
        <div class="card-body">
            <h5 class="mb-4">{{ __('My Profile') }}</h5>

            <div class="row g-3 mb-3">
                {{-- Business Logo --}}
                <div class="col-md-6">
                    <label for="avatar" class="form-label">{{ __('Profile Image') }}</label>
                    <x-img name="avatar" :old="$user->avatar" :ref="'avatar'" :name="'avatar'"></x-img>
                </div>
            </div>

            <div class="row g-3">
                <div class="col-md-6">
                    <label for="first_name" class="form-label">{{ __('First Name') }}</label>
                    <input type="text" id="first_name" name="first_name" class="form-control"
                           value="{{ $user->first_name }}">
                </div>
                <div class="col-md-6">
                    <label for="last_name" class="form-label">{{ __('Last Name') }}</label>
                    <input type="text" id="last_name" name="last_name" class="form-control"
                           value="{{ $user->last_name }}">
                </div>
            </div>

            <div class="row g-3 mt-2">
                <div class="col-md-6">
                    <label for="username" class="form-label">{{ __('Username') }}</label>
                    <input type="text" id="username" name="username" class="form-control"
                           value="{{ $user->username }}">
                </div>
                <div class="col-md-6">
                    <label for="gender" class="form-label">{{ __('Gender') }}</label>
                    <select class="form-select" id="gender" name="gender">
                        <option value="M" {{ $user->gender == 'M' ? 'selected' : '' }}>Male</option>
                        <option value="F" {{ $user->gender == 'F' ? 'selected' : '' }}>Female</option>
                    </select>
                </div>
            </div>

            <div class="row g-3 mt-2">
                <div class="col-md-6">
                    <label for="birthday" class="form-label">{{ __('Birthday') }}</label>
                    <input type="date" id="birthday" name="birthday" class="form-control"
                           value="{{ $user->birthday }}">
                </div>
                <div class="col-md-6">
                    <label for="email" class="form-label">{{ __('Email') }}
                        @if($user->email_verified_at)
                            <span class="badge bg-success">{{ __('Verified') }}</span>
                        @else
                            <span class="badge bg-danger text-danger-fg">{{ __('Not Verified') }}</span>
                        @endif
                    </label>
                    <input type="email" id="email" name="email" class="form-control" value="{{ $user->email }}">
                </div>
            </div>

            <div class="row g-3 mt-2">
                <div class="col-md-6">
                    <label for="phone" class="form-label">{{ __('Phone') }}</label>
                    <input type="tel" id="phone" name="phone" class="form-control" value="{{ $user->phone }}">
                </div>
                <div class="col-md-6">
                    <label for="country" class="form-label">{{ __('Country') }}</label>
                    <input type="text" id="country" class="form-control" value="{{ $user->country }}"
                           placeholder="Enter country" disabled>
                </div>
            </div>

            <div class="row g-3 mt-2">
                <div class="col-12">
                    <label for="address" class="form-label">{{ __('Address') }}</label>
                    <input type="text" id="address" name="address" class="form-control" value="{{ $user->address }}"
                           placeholder="Enter your address">
                </div>
            </div>

            <div class="d-flex justify-content-end mt-4">
                <button type="submit" class="btn btn-primary">
                    <x-icon name="check" height="20" class="me-1"/> {{ __('Update Profile') }}
                </button>
            </div>
        </div>
    </form>

@endsection
