<div class="single-form-card">
    {{-- KYC Template Title Header --}}
    <div class="card-header bg-sky-2">
        <h6 class="mb-0 text-secondary">{{ $template->title }}</h6>
        <p class="mb-0 text-muted small">{{ $template->description }}</p>
    </div>

    {{-- KYC Template Form Section --}}
    <div class="card-body">
        <form action="{{ route('user.settings.kyc.submit') }}" method="POST" enctype="multipart/form-data">
            @csrf
            <input type="hidden" name="template_id" value="{{ $template->id }}">
            <div class="row g-3">
                @foreach($template->fields as $field)
                    <div class="col-12">
                        <label for="credentials[{{ $field['label'] }}]" class="form-label">
                            {{ ucfirst(str_replace('_', ' ', $field['label'])) }}
                        </label>
                        @if($field['type'] === 'file')
                            <input type="file"
                                   id="credentials[{{ $field['label'] }}]"
                                   name="credentials[{{ $field['label'] }}]"
                                   class="form-control"
                                   placeholder="{{ ucfirst(str_replace('_', ' ', $field['label'])) }}"
                                    {{ !empty($field['validation']) && $field['validation'] ? 'required' : '' }}>
                        @else
                            <input type="{{ $field['type'] }}"
                                   id="credentials[{{ $field['label'] }}]"
                                   name="credentials[{{ $field['label'] }}]"
                                   class="form-control"
                                   placeholder="{{ ucfirst(str_replace('_', ' ', $field['label'])) }}"
                                    {{ !empty($field['validation']) && $field['validation'] ? 'required' : '' }}>
                        @endif
                    </div>
                @endforeach
            </div>
        </form>
    </div>
</div>
