@php use App\Enums\NotificationActionType; @endphp
@extends('frontend.user.setting.index')
@section('title', __('Notifications'))
@section('user_setting_content')
<div class="card notification-card">
    {{-- Header --}}
    <header class="notification-header">
        <h5 class="notification-header__title">
            <i class="fa fa-bell me-2"></i> {{ __('Notifications') }}
        </h5>
    </header>
    <div class="card-body p-0">
        @if($notifications->isNotEmpty())
            <ul class="notification-all-list list-group list-group-flush">
                @foreach($notifications as $notification)
                    @php
                        $data   = $notification->data;
                        $isRead = ! is_null($notification->read_at);
                    @endphp
                    
                    <li class="notification-item list-group-item">
                        {{-- Icon --}}
                        <div class="notification-item__icon">
                            <x-icon
                                name="{{ $data['icon'] }}"
                                class="notification-item__icon-svg text-{{ \App\Enums\NotificationActionType::getClass($data['action_type']) }}"
                                height="38"
                                width="38"
                            />
                        </div>
                        
                        {{-- Content --}}
                        <div class="notification-item__content">
                            <div class="notification-item__title">
                                {{ $data['title'] ?? __('No message available') }}
                            </div>
                            <div class="notification-item__message">
                                {{ $data['message'] }}
                            </div>
                        </div>
                        
                        {{-- Meta: Time + Mark-as-Read --}}
                        <div class="notification-item__meta">
                            <time class="notification-item__time">
                                {{ $notification->created_at->format('d M, Y H:i A') }}
                            </time>
                            
                            @unless($isRead)
                                <a
                                    href="{{ route('user.notifications.markAsRead', $notification->id) }}"
                                    class="notification-item__mark-read"
                                    title="{{ __('Mark as read') }}"
                                >
                                    <i class="fa-sharp fa-solid fa-circle-check"></i>
                                </a>
                            @endunless
                        </div>
                    </li>
                @endforeach
            </ul>
            
            {{-- Pagination --}}
            @if($notifications->hasPages())
                <footer class="notification-footer card-footer bg-white text-center">
                    {{ $notifications->links() }}
                </footer>
            @endif
        @else
            <div class="alert text-center m-3">
                {{ __('No notifications found') }}
            </div>
        @endif
    </div>
</div>

@endsection
