@php use App\Enums\KycStatus; @endphp
@extends('frontend.user.setting.index')
@section('title', __('KYC Verification'))
@section('user_setting_content')
    @php
        $kycSubmission = auth()->user()->kycSubmission;
        $kycStatus = $kycSubmission->status ?? null;
    @endphp
    @if($kycSubmission)
        @switch($kycStatus)
            @case(KycStatus::PENDING)
                <div class="main-notice-card mb-30">
                    <h6>{{ __('KYC Verification') }} <span class="text-primary kyc-status">{{ __('Pending') }}</span>
                    </h6>
                    <p>{{ __('Your KYC verification is currently pending, please wait for the admin to review your KYC.') }}</p>
                </div>
                @break

            @case(KycStatus::APPROVED)
                <div class="main-notice-card mb-30">
                    <h6>{{ __('KYC Verification') }} <span class="text-success kyc-status">{{ __('Approved') }}</span>
                    </h6>
                    <p>{{ __('Your KYC verification has been approved, you can now access all features.') }}</p>
                </div>
                @break

            @case(KycStatus::REJECTED)
                <div class="main-notice-card mb-30">
                    <h6>{{ __('KYC Verification') }} <span class="text-danger kyc-status">{{ __('Rejected') }}</span>
                    </h6>
                    <p>{{ $kycSubmission->notes ?? __('Your KYC verification has been rejected, please try again.') }}</p>
                </div>
                @break
        @endswitch
    @endif

    @if(!$kycSubmission || $kycStatus == KycStatus::REJECTED)
        <h6 class="mb-4 mt-4">{{ __('KYC Verification') }}</h6>

        <form action="{{ route('user.settings.kyc.submit') }}" method="POST" enctype="multipart/form-data">
            @csrf
            <div class="single-select-inner style-border">
                <label class="form-label">{{ __('KYC Type') }}</label>
                <select class="form-select" name="template_id" id="template-select">
                    <option disabled selected>{{ __('Select Type') }}</option>
                    @foreach($kycTemplates as $kycTemplate)
                        <option value="{{ $kycTemplate->id }}">{{ $kycTemplate->title }}</option>
                    @endforeach
                </select>
            </div>
            <div id="template-details" class="mt-3"></div>
            <div class="single-input-inner style-border mb-3 mt-3">
                <label class="form-label">{{ __('Note (Optional)') }}</label>
                <textarea class="rounded" name="note" id="" cols="10" rows="10"></textarea>
            </div>

            <div class="d-flex justify-content-end mt-4">
                <button type="submit" class="btn btn-primary">
                    <x-icon name="check" height="20"/> {{ __('Submit Verification') }}
                </button>
            </div>

        </form>
    @endif
@endsection
@push('scripts')
    <script>
        "use strict";

        const $templateSelect = $('#template-select');
        const $templateDetails = $('#template-details');

        $templateSelect.on('change', function () {
            const templateId = $(this).val();

            if (!templateId) {
                $templateDetails.empty();
                return;
            }

            // Show a loading spinner
            $templateDetails.html(`
        <div class="d-flex justify-content-center my-3">
            <div class="spinner-border text-primary" role="status">
                <span class="visually-hidden">Loading...</span>
            </div>
        </div>
    `);
            const url = `{{ route('user.settings.kyc.template.details', ':id') }}`.replace(':id', templateId);
            $.get(url)
                .done(response => {
                    $templateDetails.html(response);
                });
        });
    </script>
@endpush
