@extends('frontend.layouts.user.index')
@section('title', __('Settings'))
@section('content')
    <div class="single-form-card">
        <div class="card-main p-4">
            <div class="tab-area mb-3">
                <nav class="nav nav-tabs bg-sky-2 rounded flex-column flex-sm-row flex-wrap text-center text-sm-start">
                    <a href="{{ route('user.settings.profile') }}"
                       class="nav-link flex-sm-fill {{ isActive('user.settings.profile') }}"
                       aria-controls="profile"
                       aria-selected="true">
                        <i class="fas fa-user"></i> {{ __('Profile') }}
                    </a>
                    <a href="{{ route('user.notifications.index') }}"
                       class="nav-link flex-sm-fill {{ isActive('user.notifications.index') }}"
                       aria-controls="notification"
                       aria-selected="false">
                        <i class="fas fa-bell"></i> {{ __('Notifications') }}
                    </a>
                    <a href="{{ route('user.settings.2fa.setup') }}"
                       class="nav-link flex-sm-fill {{ isActive('user.settings.2fa.setup') }}"
                       aria-controls="security"
                       aria-selected="false">
                        <i class="fas fa-shield-alt"></i> {{ __('2FA Security') }}
                    </a>
                    <a href="{{ route('user.settings.password.change') }}"
                       class="nav-link flex-sm-fill {{ isActive('user.settings.password.change') }}"
                       aria-controls="password-change"
                       aria-selected="false">
                        <i class="fas fa-lock"></i> {{ __('Change Password') }}
                    </a>
                    <a href="{{ route('user.settings.kyc.verify') }}"
                       class="nav-link flex-sm-fill {{ isActive('user.settings.kyc.verify') }}"
                       aria-controls="kyc-verification"
                       aria-selected="false">
                        <i class="fas fa-id-card"></i> {{ __('KYC Verification') }}
                    </a>
                    
                    <a href="#" onclick="event.preventDefault(); document.getElementById('logout-form').submit();"
                       class="nav-link flex-sm-fill d-lg-none d-block">
                        <i class="fas fa-sign-out-alt color-red"></i>
                        {{ __('Logout') }}
                    </a>
                    <form id="logout-form" method="POST" action="{{ route('logout') }}">
                        @csrf
                    </form>
                </nav>

                <div class="tab-content mt-3">
                    <div class="tab-pane fade show active" id="profile" role="tabpanel" aria-labelledby="profile-tab">
                        @yield('user_setting_content')
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
