@extends('frontend.user.setting.index')
@section('title', __('Settings'))
@section('user_setting_content')
    <form action="{{ route('user.settings.password.update') }}" method="post" enctype="multipart/form-data">
        @csrf
        <div class="card-body">
            <h5 class="mb-4">{{ __('Update Password') }}</h5>
            <div class="mb-3">
                <label class="form-label" for="old-password">{{ __('Current Password') }}</label>
                <input type="password" name="old_password" id="old-password" class="form-control" placeholder="{{ __('Current Password') }}" required>
            </div>
            <div class="mb-3">
                <label class="form-label" for="password">{{ __('New Password') }}</label>
                <input type="password" name="password" id="password" class="form-control" placeholder="{{ __('New Password') }}" required>
            </div>
            <div class="mb-3">
                <label class="form-label" for="password_confirmation">{{ __('Confirm New Password') }}</label>
                <input type="password" name="password_confirmation" id="password_confirmation" class="form-control" placeholder="{{ __('Confirm New Password') }}" required>
            </div>
            <div class="d-flex justify-content-end mt-3">
                <button type="submit" class="btn btn-primary">
                    <x-icon name="check" height="20" class="me-1"/> {{ __('Update Password') }}
                </button>
            </div>
        </div>
    </form>
@endsection
