@extends('frontend.user.setting.index')
@section('title', __('Security Settings'))

@section('user_setting_content')
       @if(auth()->user()->two_factor_enabled)
           {{-- Disable Two-Factor Authentication --}}
           <div class="pb-3 mb-3 mt-4 border-bottom">
               <div class="element-text-box">
                   <h5 class="main-title mb-2">{{ __('Disable Two-Factor Authentication (2FA)') }}</h5>
                   <p class="small mb-2">
                       {{ __('Two-Factor Authentication (2FA) adds an extra layer of security by requiring a one-time verification code from your authenticator app during login.') }}
                   </p>
                   <p class="text-danger small">
                       {{ __('Disabling 2FA will remove this additional security measure, making your account more vulnerable to unauthorized access.') }}
                   </p>
               </div>
           </div>

           {{-- Disable 2FA Form --}}
           <div class="w-100">
               <form action="{{ route('user.settings.2fa.disable') }}" method="POST" class="needs-validation">
                   @csrf
                   <div class="input-group mt-3">
                       <input
                               type="password"
                               class="form-control"
                               name="password"
                               placeholder="{{ __('Enter your current password') }}"
                               required
                       >
                   </div>
                   <button type="submit" class="btn btn-danger mt-3 w-100">
                       <x-icon name="security-off" height="20" width="20" class="me-1" />
                       {{ __('Disable 2FA') }}
                   </button>
               </form>
           </div>

       @else
           {{-- Enable Two-Factor Authentication --}}
           <div class="pb-3 mb-3 mt-4 border-bottom">
               <div class="element-text-box">
                   <h5 class="main-title mb-2">{{ __('Enable Two-Factor Authentication (2FA)') }}</h5>
                   <p class="small mb-2">
                       {{ __('Enhance your account security by enabling Two-Factor Authentication (2FA). This ensures that only you can access your account, even if your password is compromised.') }}
                   </p>
                   <p class="small">
                       {{ __('Follow these steps to enable 2FA on your account:') }}
                   </p>
               </div>
           </div>

           {{-- QR Code & Instructions --}}
           <div class="pb-3 mb-3 border-bottom">
               <div class="row g-2 align-items-center">
                   {{-- QR Code --}}
                   <div class="col-auto text-center text-md-start">
                       <img
                               src="{{ $qrCode }}"
                               alt="{{ __('QR Code for Google Authenticator') }}"
                               class="img-fluid rounded shadow-sm d-block mx-auto mx-md-0"
                               style="max-width: 180px; height: auto;"
                       >
                   </div>

                   {{-- Instructions --}}
                   <div class="col">
                       <h6 class="main-title style-small mb-2">{{ __('Set Up Your Authenticator App') }}</h6>
                       <ul class="list-unstyled small mb-0">
                           <li class="mb-1">
                               {{ __('Step 1: Download the Google Authenticator app from the Google Play Store or Apple App Store.') }}
                           </li>
                           <li class="mb-1">
                               {{ __('Step 2: Scan the QR code above using your Google Authenticator app, or enter the key manually.') }}
                           </li>
                           <li class="mb-1">
                               <strong>{{ __('Account Name:') }}</strong> {{ setting('site_title') }}
                           </li>
                           <li class="mb-1">
                               <strong>{{ __('Secret Key:') }}</strong> {{ $secret }}
                           </li>
                       </ul>
                   </div>
               </div>
           </div>

           {{-- Verification Form --}}
           <div class="w-100">
               <div class="element-text-box">
                   <h6 class="main-title style-small mb-2">{{ __('Verify and Activate 2FA') }}</h6>
                   <p class="small mb-2">
                       {{ __('Enter the 6-digit verification code generated by your Google Authenticator app to complete the setup.') }}
                   </p>
               </div>

               <form action="{{ route('user.settings.2fa.enable') }}" method="POST" class="needs-validation">
                   @csrf
                   <div class="input-group mt-3">
                       <input
                               type="text"
                               class="form-control"
                               name="verification_code"
                               placeholder="{{ __('Enter the 6-digit code') }}"
                               required
                       >
                   </div>
                   <button type="submit" class="btn btn-primary mt-3 w-100">
                       <x-icon name="check" height="20" width="20" class="me-1"/>
                       {{ __('Enable 2FA') }}
                   </button>
               </form>
           </div>
       @endif
@endsection
