@extends('frontend.layouts.user.index')
@section('title', __('Request Money'))
@section('content')
    @include('frontend.user.partials._feature_summary_statistics', ['trxType' => \App\Enums\TrxType::RECEIVE_MONEY])

    <div class="row">
        <div class="col-lg-12 col-xl-7">
            <div class="single-form-card">
                <div class="card-title mb-0 d-flex flex-wrap justify-content-between align-items-center">
                    <h6 class="mb-0 text-white">{{ __('Request Money') }}</h6>
                    <a class="btn btn-light-success btn-sm" href="{{ route('user.transaction.index', ['type' => \App\Enums\TrxType::REQUEST_MONEY]) }}">
                        <i class="fas fa-list"></i> {{ __('History') }}
                    </a>
                </div>

                <div class="card-main">
                    <form action="{{ route('user.request-money.store') }}" method="POST" onsubmit="disableSubmitButton(this, '{{ __('Processing...') }}')">
                        @csrf
                        {{-- Payer Input --}}
                        <div class="single-input-inner style-border">
                            <label class="form-label">{{ __('Payer') }}</label>
                            <input type="text" class="form-control recipient-input" name="recipient"
                                   placeholder="{{ __('Enter Email or Wallet ID') }}">
                            <span class="small color-base fw-500 recipient-info"></span>
                        </div>

                        {{-- Wallet Selector --}}
                        <div class="single-select-inner style-border">
                            <label>{{ __('Your Wallets') }}</label>
                            <select class="form-select wallet-select" name="wallet_id">
                                <option disabled selected>{{ __('Select Wallet') }}</option>
                            </select>
                            <span class="small color-base fw-500 wallet-info"></span>
                        </div>

                        {{-- Amount Input --}}
                        <div class="single-input-inner style-border mb-0 mt-3">
                            <label class="form-label">{{ __('Request Amount') }}</label>
                            <div class="input-group">
                                <input type="text" class="form-control amount-input" name="amount"
                                       placeholder="{{ __('Enter Amount') }}"
                                       oninput="this.value = validateDouble(this.value)">
                                <span class="input-group-text">{{ siteCurrency() }}</span>
                            </div>
                            <span class="small color-base fw-500 send-amount-info"></span>
                        </div>

                        <div class="single-input-inner style-border mb-0 mt-3">
                            <label class="form-label">{{ __('Note (Optional)') }}</label>
                            <textarea class=" rounded" name="note" id="" cols="10" rows="10"></textarea>
                        </div>

                        {{-- Submit Button --}}
                        <button type="submit" class="btn btn-base w-100 mt-4 submit-btn">
                            <x-icon name="check" height="20"/>
                            {{ __('Request Now') }}
                        </button>
                    </form>
                </div>
            </div>
        </div>

        @include('frontend.user.request_money.partials._summary')
    </div>
@endsection

@push('scripts')
    @include('frontend.user.request_money.partials._script')
@endpush
