<div class="col-12">
    <div class="single-form-card">
        <div class="card-title d-flex flex-column flex-md-row justify-content-between">
            <h6 class="text-white mb-2 mb-md-0">{{ __('Referral Earnings') }}</h6>
        </div>
        <div class="card-main">
            <div class="transaction-list">
                @forelse($referralsRewards as $referralsReward)
                    <div class="transaction-item d-flex align-items-center p-2 rounded mb-2">
                        {{-- Details --}}
                        <div class="transaction-details flex-grow-1">
                            <div class="d-flex justify-content-between align-items-start">
                                <div>
                                    <span class="fw-bold text-dark">{{ $referralsReward->description }}</span>
                                    <div class="text-muted small mt-1">
                                        {{ __('TRX') }}: {{ strtoupper($referralsReward->trx_id) }}
                                    </div>
                                </div>
                                <div class="text-end">
                                    <span class="fw-bold d-block text-success">{{ '+' . number_format($referralsReward->amount, 2) }} {{ $referralsReward->currency }}</span>
                                    <div class="text-muted small mt-1">
                                        {{ $referralsReward->created_at->format('d M Y, h:i A') }}
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                @empty
                    <div class="text-center text-muted">{{ __('No Referral Earnings found.') }}</div>
                @endforelse
            </div>
            {{-- Pagination --}}
            @if($referralsRewards->hasPages())
                <div class="mt-3 d-flex justify-content-center">
                    {{ $referralsRewards->links() }}
                </div>
            @endif
        </div>
    </div>
</div>
