<div class="referral-tree">
    <ul>
        <li class="referral-root">
            <a href="javascript:void(0);">
                <div class="referral-info">
                    <img src="{{ asset(Auth::user()->avatar_alt) }}" alt="Avatar" class="avatar">
                    <div>
                        <strong>{{ Auth::user()->name }} ({{ Auth::user()->username }})</strong>
                        <span>{{ __('Referrals : :count', ['count' => $referrals->count()]) }}</span>
                    </div>
                </div>
            </a>
            @if($referrals->isNotEmpty())
                <ul class="d-block">
                    @foreach ($referrals as $referral)
                        <li>
                            <a href="javascript:void(0);">
                                <div class="referral-info">
                                    <img src="{{ asset($referral->referredUser->avatar_alt) }}" alt="Avatar" class="avatar">
                                    <div>
                                        <strong>{{ $referral->referredUser->name ?? 'Unknown' }} ({{ $referral->referredUser->username }})</strong>
                                        <span>{{ __('Referrals : :count', ['count' => $referral->childReferrals->count()]) }}</span>
                                    </div>
                                </div>
                            </a>
                            @if ($referral->childReferrals->isNotEmpty())
                                <ul>
                                    @foreach ($referral->childReferrals as $child)
                                        <li>
                                            <a href="javascript:void(0);">
                                                <div class="referral-info">
                                                    <img src="{{ asset($child->referredUser->avatar_alt) }}" alt="Avatar" class="avatar">
                                                    <div>
                                                        <strong>{{ $child->referredUser->name ?? 'Unknown' }} ({{ $child->referredUser->username }})</strong>
                                                        <span>{{ __('Referrals : :count', ['count' => $child->childReferrals->count()]) }}</span>
                                                    </div>
                                                </div>
                                            </a>
                                        </li>
                                    @endforeach
                                </ul>
                            @endif
                        </li>
                    @endforeach
                </ul>
            @endif
        </li>
    </ul>
</div>
