@extends('frontend.layouts.user.index')
@section('title', __('All Ranks'))
@section('content')
    @php
        $rankNames = $userRanks->pluck('name')->implode(', ');
        $minReward = siteCurrency('symbol') . $userRanks->min('reward');
        $maxReward = siteCurrency('symbol') . $userRanks->max('reward');
        $maxWallets = $userRanks->max('features.wallet_create') === 'unlimited' ? __('unlimited') : $userRanks->max('features.wallet_create');
        $maxReferral = $userRanks->max('features.referral_level');
    @endphp
    <div class="row">
        <div class="col-12">
            <div class="single-form-card">
                <div class="card-main bg-sky-2 d-flex flex-column flex-lg-row align-items-center p-4">
                    <div class="bg-sky-2 p-4 b-radius-16 w-100 overflow-scroll">
                        <h6 class="">{{ __('Explore All Ranks') }}</h6>
                        <p class="border-bottom-1 pb-3 mb-5 small text-muted">
                            {{ __('Unlock rewards, wallet creation limits, and referral levels as you advance through ranks: :ranks—offering increasing benefits from :minReward to :maxReward rewards, up to :maxWallets wallets, and up to :maxReferral referral levels.', [
                                'ranks' => $rankNames,
                                'minReward' => $minReward,
                                'maxReward' => $maxReward,
                                'maxWallets' => $maxWallets,
                                'maxReferral' => $maxReferral,
                            ]) }}
                        </p>
                        <div class="all-badge-inner">
                            <ul>
                                @foreach($userRanks as $rank)
                                    
                                    @php( $isActive = $rank->id === auth()->user()->rank_id || in_array($rank->id, (auth()->user()->old_ranks ?? [])))
                                    <li @class(['active' => $isActive])
                                        title="{{ $rank->description }}"
                                        data-bs-toggle="tooltip"
                                        data-bs-placement="top" >
                                        <img class="border-img"
                                             src="{{ asset('general/static/rank/badge-border.png') }}" alt="img">
                                        <img class="lock-img" src="{{ asset('general/static/rank/badge-lock.png') }}"
                                             alt="img">
                                        <div class="single-badge-inner">
                                            <div class="badge-wrap">
                                                <img src="{{ asset($rank->icon) }}" alt="img">
                                                <h6 class="text-white">{{ __(':name Member', ['name' => $rank->name]) }} </h6>
                                                <p>{{ __(':reward reward, :wallet wallets, :referral referral levels!', ['reward' => siteCurrency('symbol').$rank->reward, 'wallet' => $rank->features['wallet_create'], 'referral' => $rank->features['referral_level']]) }}</p>
                                            </div>
                                        </div>
                                    </li>
                                @endforeach

                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
@endsection
