@extends('frontend.layouts.user.index')
@section('title', __('Merchants'))
@section('content')
    <div class="row">
        <div class="col-12">
            <div class="card single-form-card">
                {{-- Card Header --}}
                <div class="card-title mb-0 d-flex flex-column flex-md-row justify-content-between align-items-center">
                    <h6 class="text-white mb-2 mb-md-0 text-center text-md-start">{{ __('Merchants') }}</h6>
                    <div class="d-flex gap-2">
                        <a class="btn btn-light-success btn-sm"
                           href="{{ route('user.transaction.index', ['type' => \App\Enums\TrxType::RECEIVE_PAYMENT]) }}">
                            <i class="fas fa-list"></i> {{ __('Payments') }}
                        </a>
                        <a class="btn btn-light-primary btn-sm" href="{{ route('user.merchant.create') }}">
                            <i class="fas fa-university"></i> {{ __('Create') }}
                        </a>
                    </div>
                </div>

                {{-- Card Body --}}
                <div class="card-body">
                    {{-- Merchants List --}}
                    <div class="transaction-list mt-4">
                        @forelse($merchants as $merchant)
                            <div class="transaction-item d-flex align-items-center p-2 rounded mb-2">
                                <div class="transaction-icon rounded d-flex align-items-center justify-content-center me-3">
                                    <img src="{{ asset($merchant->business_logo) }}" alt="">
                                </div>

                                <div class="transaction-details flex-grow-1">
                                    <div class="d-flex justify-content-between align-items-start">
                                        <div>
                                            <span class="fw-bold text-dark">{{ $merchant->business_name }}</span>
                                            <div class="small fw-bold mt-1  text-uppercase bg-transparent ">
                                                {{ __('Currency : :currency', ['currency' => $merchant->currency->code]) }}
                                            </div>
                                            <div class="text-muted small mt-1">
                                                {{ $merchant->site_url }}
                                            </div>
                                        </div>
                                        <div class="text-end">
                                            <span class="fw-bold d-block">
                                                 {{ __('Total Payments:')  }} 00 {{ $merchant->currency->symbol }}

                                            </span>

                                            <x-badge :status="$merchant->status"/>
                                            <div class="text-muted small fw-bold mt-1">
                                                <a href="{{ route('user.merchant.edit', $merchant->id) }}" class="me-1 text-uppercase">
                                                    <i class="fas fa-edit"></i>{{ __('Edit') }}
                                                </a>
                                                <a href="{{ route('user.merchant.config', $merchant->id) }}" class="text-secondary text-uppercase">
                                                    <i class="fas fa-key"></i>{{ __('Config') }}
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @empty
                            <div class="text-center text-muted">{{ __('No merchants found') }}</div>
                        @endforelse
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

