@extends('frontend.layouts.user.index')
@section('title', __('Edit Merchant'))
@section('content')
    <div class="row">
        <div class="col-12">
            <div class="card single-form-card">
                {{-- Card Header --}}
                <div class="card-title d-flex flex-column flex-md-row justify-content-between">
                    <h6 class="text-white mb-2 mb-md-0">{{ __('Edit Merchant') }}</h6>
                    <div class="d-flex gap-2 flex-row">
                        <a href="#" class="btn btn-light-success btn-sm">
                            <i class="fas fa-list"></i> {{ __('Transactions') }}
                        </a>
                        <a href="{{ route('user.merchant.index') }}" class="btn btn-light-primary btn-sm">
                            <i class="fas fa-shop"></i> {{ __('Merchants') }}
                        </a>
                    </div>
                </div>

                {{-- Card Body --}}
                <div class="card-main">
                    <div class="text-muted small fw-500 border-left-5 rounded p-2 mb-3 bg-light d-flex align-items-center"
                         role="alert" aria-live="assertive">
                        {{ __('Update your merchant details. If the currency is changed, admin approval is required for the update to take effect.') }}
                    </div>

                    <form action="{{ route('user.merchant.update', $merchant->id) }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        @method('PUT')

                        <div class="row g-3">
                            {{-- Business Logo --}}
                            <div class="col-md-6">
                                <label for="business_logo" class="form-label">{{ __('Business Logo (Optional)') }}</label>
                                <x-img name="business_logo" :old="old('business_logo', $merchant->business_logo)"
                                       :ref="'business-logo'" :name="'business_logo'"></x-img>
                            </div>
                        </div>

                        <div class="row g-3">
                            {{-- Business Name --}}
                            <div class="col-md-6">
                                <div class="mb-2 single-input-inner style-border">
                                    <label for="business_name" class="form-label">{{ __('Business Name') }}</label>
                                    <input type="text" class="form-control" id="business_name" name="business_name"
                                           value="{{ old('business_name', $merchant->business_name) }}" required
                                           placeholder="{{ __('Enter your business name') }}">
                                </div>
                            </div>

                            {{-- Business Email --}}
                            <div class="col-md-6">
                                <div class="mb-2 single-input-inner style-border">
                                    <label for="business_email" class="form-label">{{ __('Business Email') }}</label>
                                    <input type="email" class="form-control" id="business_email" name="business_email"
                                           value="{{ old('business_email', $merchant->business_email) }}" required
                                           placeholder="{{ __('Enter your business email') }}">
                                </div>
                            </div>

                            {{-- Website --}}
                            <div class="col-md-6">
                                <div class="mb-2 single-input-inner style-border">
                                    <label for="site_url" class="form-label">{{ __('Website') }}</label>
                                    <input type="url" class="form-control" id="site_url" name="site_url"
                                           value="{{ old('site_url', $merchant->site_url) }}"
                                           placeholder="{{ __('https://yourwebsite.com') }}">
                                </div>
                            </div>

                            {{-- Currency --}}
                            <div class="col-md-6">
                                <div class="mb-2 single-input-inner style-border">
                                    <label for="currency_id" class="form-label">{{ __('Currency') }}
                                        <i data-bs-toggle="tooltip" data-bs-placement="top"
                                           title="{{ __('Currency will be retrieved from your active wallet list') }}"
                                           class="fa-solid fa-circle-info ms-1"></i>
                                    </label>
                                    <select class="form-select" id="currency_id" name="currency_id">
                                        <option value="" disabled>{{ __('Select Currency') }}</option>
                                        @foreach($currencies as $currency)
                                            <option value="{{ $currency->id }}"
                                                    {{ old('currency_id', $merchant->currency_id) == $currency->id ? 'selected' : '' }}>
                                                {{ $currency->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            {{-- Business Overview --}}
                            <div class="col-12">
                                <div class="mb-2">
                                    <label for="business_description" class="form-label">{{ __('Business Overview') }}</label>
                                    <textarea class="form-control h-25" id="business_description"
                                              name="business_description" placeholder="{{ __('Describe your business') }}">{{ old('business_description', $merchant->business_description) }}</textarea>
                                </div>
                            </div>
                        </div>

                        {{-- Submit Button --}}
                        <button type="submit" class="btn btn-primary mt-4">
                            <x-icon name="check" height="22" /> {{ __('Update Merchant') }}
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
