@extends('frontend.layouts.user.index')
@section('title', __('Merchant API Configuration'))

@section('content')
    <div class="single-form-card">
        <div class="card-title d-flex flex-column flex-md-row justify-content-between">
            <h6 class="text-white mb-2 mb-md-0"> <i class="fas fa-cogs me-2"></i> {{ __('Merchant API Configuration') }}</h6>
            <div class="d-flex gap-2 flex-row">
                <a href="{{ route('user.merchant.index') }}" class="btn btn-light-primary btn-sm">
                    <i class="fas fa-arrow-left"></i> {{ __('Back to Merchants') }}
                </a>
            </div>
        </div>

        <div class="card-main">

            {{-- Security Warning --}}
            <div class="text-muted bg-light-warning fw-500 border-warning-left-5  rounded text-white p-3 mb-4  d-flex align-items-center " role="alert" aria-live="assertive">
                <i class="fas fa-exclamation-triangle text-warning me-2"></i> {{ __('Keep your API credentials secure and do not share them with unauthorized persons.') }}
            </div>

            {{-- API Benefits --}}
            <div class="d-flex align-items-center border-bottom pb-3 mb-3 w-100 justify-content-between">
                <div class="element-text-box">
                    <h6 class="main-title mb-1">
                        <span class="me-2">🚀</span>{{ __('Benefits of :name API Integration', ['name' => setting('site_title')]) }}
                    </h6>
                    <p class="mb-0">
                        {{ __('Seamlessly integrate payments into any script, support multiple payment gateways, and allow Digikash users to pay your company using their wallets. A developer-friendly and flexible solution!') }}
                    </p>
                </div>
            </div>

            {{-- API Credentials --}}
            <div class="d-flex align-items-center border-bottom mb-4 w-100 justify-content-between">
                <div class="element-text-box pe-5">
                    <h6 class="main-title style-small mb-1"><i class="fas fa-id-badge text-muted me-2"></i> {{ __('Merchant ID') }}</h6>
                    <p class="mb-2 text-muted">
                        {{ $merchant->merchant_key }}
                        <i class="fa-solid fa-copy  copy-icon copyNow"
                           data-clipboard-text="{{ $merchant->merchant_key }}"
                           title="{{ __('Copy Merchant Key') }}"
                           data-bs-toggle="tooltip"
                           data-bs-placement="top"></i>
                    </p>
                </div>
            </div>

            <div class="d-flex align-items-center border-bottom mb-4 w-100 justify-content-between">
                <div class="element-text-box pe-5">
                    <h6 class="main-title style-small mb-1"><i class="fas fa-key text-muted me-2"></i> {{ __('API Key') }}</h6>
                    <p class="mb-2 text-muted">
                        {{ $merchant->api_key }}
                        <i class="fa-solid fa-copy  copy-icon copyNow"
                           data-clipboard-text="{{ $merchant->api_key }}"
                           title="{{ __('Copy API Key') }}"
                           data-bs-toggle="tooltip"
                           data-bs-placement="top"></i>
                    </p>
                </div>
            </div>

            <div class="d-flex align-items-center border-bottom mb-4 w-100 justify-content-between">
                <div class="element-text-box pe-5">
                    <h6 class="main-title style-small  mb-1">
                        <i class="fas fa-shield-alt text-danger text-muted me-2"></i> {{ __('API Secret Key') }}
                    </h6>
                    <p class="mb-2 text-muted">
                        {{ $merchant->api_secret }}
                        <i class="fa-solid fa-copy copy-icon copyNow"
                           data-clipboard-text="{{ $merchant->api_secret }}"
                           title="{{ __('Copy Secret Key') }}"
                           data-bs-toggle="tooltip"
                           data-bs-placement="top"></i>
                    </p>
                </div>
            </div>

            {{-- API Documentation --}}
            <div class="d-flex align-items-center pt-3 mt-3 w-100 justify-content-between">
                <div>
                    <h6 class="mb-1"><i class="fas fa-book me-2 text-info"></i> {{ __('API Implementation Guide') }}
                    </h6>
                    <p class="mb-0">{{ __('Refer to the API documentation for integration details.') }}</p>
                </div>
                <a href="{{ route('api-docs.index') }}" class="btn btn-light-primary btn-sm">
                    <i class="fas fa-external-link-alt"></i> {{ __('View Documentation') }}
                </a>
            </div>
        </div>
    </div>
@endsection

