@extends('frontend.layouts.user.index')
@section('title', __('Exchange Money'))
@section('content')
    @include('frontend.user.partials._feature_summary_statistics', ['trxType' => \App\Enums\TrxType::EXCHANGE_MONEY])

    <div class="row">
        <div class="col-lg-12 col-xl-7">
            <div class="single-form-card">
                <div class="card-title mb-0 d-flex flex-wrap justify-content-between align-items-center">
                    <h6 class="mb-0 text-white">{{ __('Exchange Money') }}</h6>
                    <a class="btn btn-light-success btn-sm" href="{{ route('user.transaction.index', ['type' => \App\Enums\TrxType::EXCHANGE_MONEY]) }}">
                        <i class="fas fa-list"></i> {{ __('History') }}
                    </a>
                </div>

                <div class="card-main">
                    <form action="{{ route('user.exchange-money.store') }}" method="POST" onsubmit="disableSubmitButton(this, '{{ __('Processing...') }}')">
                        @csrf
                        {{-- Source Wallet --}}
                        <div class="single-select-inner style-border">
                            <label>{{ __('From Wallet') }}</label>
                            <select class="form-select source-wallet-select" name="source_wallet_id">
                                <option disabled selected>{{ __('Select Source Wallet') }}</option>
                                @foreach($userWallets as $wallet)
                                    <option
                                            value="{{ $wallet->uuid }}"
                                            data-currency="{{ $wallet->currency->code }}"
                                            data-balance="{{ $wallet->balance }}"
                                            data-fee-type="{{ $wallet->currency->roles->first()->fee_type }}"
                                            data-fee="{{ $wallet->currency->roles->first()->fee }}"
                                            data-default-conversion-rate="{{ $wallet->currency->exchange_rate }}"
                                            data-min-limit="{{ $wallet->currency->roles->first()->min_limit }}"
                                            data-max-limit="{{ $wallet->currency->roles->first()->max_limit }}">
                                        {{ $wallet->name }}
                                        - {{ $wallet->currency->symbol }}{{ $wallet->balance }}
                                    </option>
                                @endforeach
                            </select>
                            <span class="small text-success fw-500 exchange-fee"></span>
                        </div>

                        {{-- Destination Wallet --}}
                        <div class="single-select-inner style-border mt-3">
                            <label>{{ __('To Wallet') }}</label>
                            <select class="form-select destination-wallet-select" name="destination_wallet_id">
                                <option disabled selected>{{ __('Select Destination Wallet') }}</option>
                                @foreach($userWallets as $wallet)
                                    <option
                                            value="{{ $wallet->uuid }}"
                                            data-currency="{{ $wallet->currency->code }}">
                                        {{ $wallet->name }}
                                    </option>
                                @endforeach
                            </select>
                            <span class="small text-danger fw-500 to-wallet-warning"></span>
                        </div>

                        {{-- Amount Input --}}
                        <div class="single-input-inner style-border mt-3">
                            <label class="form-label">{{ __('Amount (in Default Currency)') }}</label>
                            <div class="input-group">
                                <input type="text" class="form-control amount-input" name="amount"
                                       placeholder="{{ __('Enter Amount') }}"
                                       oninput="this.value = validateDouble(this.value)">
                                <span class="input-group-text">{{ siteCurrency() }}</span>
                            </div>
                            <span class="small color-base fw-500 send-amount-info"></span>
                        </div>

                        {{-- Submit Button --}}
                        <button type="submit" class="btn btn-base w-100 mt-4 submit-btn">
                            <x-icon name="check" height="20"/>
                            {{ __('Exchange Now') }}
                        </button>
                    </form>
                </div>
            </div>
        </div>

        @include('frontend.user.exchange_money.partials._summary')
    </div>
@endsection

@push('scripts')
    @include('frontend.user.exchange_money.partials._script')
@endpush
