<script>
    "use strict";

    // Define soft gradient colors
    const successColor = ["rgba(100, 130, 255, 0.75)", "rgba(170, 190, 255, 0.5)"]; // Softer Blue Gradient
    const failColor = ["rgba(245, 90, 90, 0.7)", "rgba(255, 160, 160, 0.5)"]; // Softer Red Gradient


    // Convert Laravel data to JavaScript arrays
    const depositData = @json($sortedDeposits);
    const withdrawData = @json($sortedWithdrawals);

    // Get max value for uniform Y-axis scaling
    function getMaxValue(data, successKey, failKey) {
        return data.reduce((maxVal, item) =>
            Math.max(maxVal, item[successKey] ?? 0, item[failKey] ?? 0), 0);
    }

    const depositMax = getMaxValue(depositData, 'success_total', 'fail_total');
    const withdrawMax = getMaxValue(withdrawData, 'withdraw_success_total', 'withdraw_fail_total');
    const globalMax = Math.max(depositMax, withdrawMax);

    /**
     * Render an ApexCharts area chart with soft border & day names.
     */
    function renderChart(elementId, categories, successData, failData, dataset, labels, yAxisMax) {
        const options = {
            series: [
                {name: labels[0], data: successData},
                {name: labels[1], data: failData}
            ],
            chart: {
                height: 200,
                type: 'area',
                toolbar: {show: false},
                sparkline: {enabled: false} // Show full chart with days
            },
            grid: {
                show: true,
                borderColor: "#EAEAEA", // Soft border
                strokeDashArray: 4
            },
            dataLabels: {enabled: false},
            stroke: {curve: 'smooth', width: 2, colors: [successColor, failColor]}, // Soft & clean strokes
            xaxis: {
                tooltip: {enabled: false},
                categories: categories, // Day names from dataset
                crosshairs: {show: false},
                labels: {
                    show: true,
                    style: {colors: "#666", fontSize: "12px"}
                }
            },

            yaxis: {
                labels: {
                    style: {colors: "#666", fontSize: "12px"}
                }
            },
            tooltip: {
                x: {formatter: (val) => "Day: " + dayMap(val)}, // Show exact day
                y: {
                    formatter: (val, {dataPointIndex}) => {
                        const symbol = dataset[dataPointIndex]?.symbol ?? '$';
                        return symbol + val.toFixed(2);
                    }
                }
            },
            fill: {
                type: "gradient",
                gradient: {
                    shadeIntensity: 0.5,
                    opacityFrom: 0.7,
                    opacityTo: 0.2,
                    stops: [0, 100]
                }
            },
            colors: [successColor[0], failColor[0]], // Success and fail colors
            markers: {size: 0, strokeWidth: 0, hover: {size: 0}}, // 0 markers for better UX
            legend: {show: false}
        };

        new ApexCharts(document.querySelector(elementId), options).render();
    }

    // Render Deposit Chart
    renderChart(
        "#deposit-chart",
        depositData.map(item => item.day), // Show day names
        depositData.map(item => item.success_total),
        depositData.map(item => item.fail_total),
        depositData,
        ['Success Deposits', 'Failed Deposits'],
        globalMax
    );

    // Render Withdraw Chart
    renderChart(
        "#withdraw-chart",
        withdrawData.map(item => item.day), // Show day names
        withdrawData.map(item => item.withdraw_success_total),
        withdrawData.map(item => item.withdraw_fail_total),
        withdrawData,
        ['Success Withdrawals', 'Failed Withdrawals'],
        globalMax
    );

    document.addEventListener("DOMContentLoaded", function() {
        let toggleBtn = document.getElementById("toggleLinksBtn");
        let hiddenLinks = document.querySelectorAll(".more-links");
        let isExpanded = false;

        if (toggleBtn) {
            toggleBtn.addEventListener("click", function() {
                hiddenLinks.forEach(el => el.classList.toggle("d-none"));
                isExpanded = !isExpanded;
                toggleBtn.textContent = isExpanded ? "{{ __('Load Less') }}" : "{{ __('Load More') }}";
            });
        }
    });
</script>



