
<div class="single-chart-inner">
    <div class="chart-head d-flex justify-content-between">
        <h6>{{ __('Recent Transactions') }}</h6>
    </div>
    <div class="details">
        <div class="transaction-list mt-1">
            @forelse($transactions as $transaction)
                @php
                    $transactionTypeClass = $transaction->trx_type->kebabCase();
                    $amountColor = $transaction->amount_flow->color($transaction->status);
                    $amountSign = $transaction->amount_flow->sign($transaction->status);
                @endphp
                <div class="transaction-item d-flex align-items-center p-2  mb-2" role="button"
                     data-bs-toggle="modal" data-bs-target="#transactionModal{{ $transaction->id }}">
                    {{-- Icon --}}
                    <div class="transaction-icon rounded d-flex align-items-center justify-content-center me-3 {{ $transactionTypeClass }}">
                        <x-icon name="{{ $transactionTypeClass }}" height="25" width="25"/>
                    </div>
                    {{-- Details --}}
                    <div class="transaction-details flex-grow-1">
                        <div class="d-flex justify-content-between align-items-start">
                            <div>
                                <span class="fw-bold text-dark">{{ $transaction->description }}</span>
                                <div class="small fw-bold mt-1  text-uppercase bg-transparent {{ $transactionTypeClass }}">
                                    {{ title($transaction->trx_type->value) }}
                                </div>
                                <div class="text-muted small mt-1">
                                    {{ __('TRX') }}: {{ strtoupper($transaction->trx_id) }}
                                </div>
                            </div>
                            <div class="text-end">
                                <span class="fw-bold d-block {{ $amountColor }}">{{ $amountSign . number_format($transaction->amount, 2) }} {{ $transaction->currency }}</span>
                                <span class="badge bg-{{ $transaction->status->color() }} mt-1 small px-2 py-1">{{ strtoupper($transaction->status->value) }}</span>
                                <div class="text-muted small mt-1">
                                    {{ $transaction->created_at->format('d M Y, h:i A') }}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                {{-- Transaction Modal --}}
                @include('frontend.user.transaction.partials._details_modal', ['transaction' => $transaction, 'transactionTypeClass' => $transactionTypeClass])
            @empty
                <div class="text-center text-muted">{{ __('No transactions found') }}</div>
            @endforelse
        </div>
    </div>
</div>

