@php
    $kyc = auth()->user()->kycSubmission;
    $kycStatus = $kyc?->status ?? null;
@endphp

@if(isActive('user.settings.kyc.verify') !== 'active' || $kycStatus !== \App\Enums\KycStatus::APPROVED)
    <div class="main-notice-card mb-30">
        <h6>
            @if(!$kyc)
                {{ __('Complete Your KYC Verification') }}
            @elseif($kycStatus === \App\Enums\KycStatus::PENDING)
                {{ __('Your KYC Verification is Pending') }}
            @elseif($kycStatus === \App\Enums\KycStatus::REJECTED)
                {{ __('Your KYC Verification was Rejected') }}
            @endif

            <a href="{{ route('user.settings.kyc.verify') }}" class="btn btn-light-success btn-sm kyc-status">
                @if(!$kyc)
                    {{ __('Verify Now') }}
                @elseif($kycStatus === \App\Enums\KycStatus::PENDING)
                    {{ __('Pending Approval') }}
                @elseif($kycStatus === \App\Enums\KycStatus::REJECTED)
                    {{ __('Resubmit KYC') }}
                @endif
            </a>
        </h6>

        <p>
            @if(!$kyc)
                {{ __('To access all features and ensure security, please complete your KYC verification.') }}
            @elseif($kycStatus === \App\Enums\KycStatus::PENDING)
                {{ __('Your KYC verification is under review. Please wait for approval.') }}
            @elseif($kycStatus === \App\Enums\KycStatus::REJECTED)
                {{ __('Your KYC verification was rejected. Please check the details and resubmit.') }}
            @endif
        </p>
    </div>
@endif
