<section class="team-section fix section-padding" id="team">
    <div class="container">
        <div class="section-title text-center">
            <span class="sub-title justify-content-center wow fadeInUp">
                @if (!empty($data['title_bar_image']))
		            <img src="{{ asset($data['title_bar_image']) }}" alt="title-bar">
	            @endif
	            {{ $data['subheading'][$locale] ?? '' }}
            </span>
	        
	        @if (!empty($data['heading'][$locale]))
		        <h2 class="wow fadeInUp" data-wow-delay=".3s">
			        {{ $data['heading'][$locale] }}
		        </h2>
	        @endif
        </div>
	    
	    <div class="row g-4">
		    @foreach($repeatedContents as $index => $repeatedContent)
			    @php
				    $contentData = $repeatedContent->content_data ?? [];
					$delay = 0.3 + ($index * 0.2);
			    @endphp
			    
			    <div class="col-xl-4 col-lg-6 col-md-6 wow fadeInUp" data-wow-delay=".{{ intval($delay * 10) }}s">
				    <div class="team-card-item">
					    @if (!empty($contentData['team_image']))
						    <div class="team-image">
							    <img src="{{ asset($contentData['team_image']) }}" alt="team-image">
						    </div>
					    @endif
					    <div class="team-content bg-cover" style="background-image: url({{ asset('general/static/component/team-shape.png') }});">
						    <h5>{{ $contentData['name'][$locale] ?? '' }}</h5>
						    <p>{{ $contentData['designation'][$locale] ?? '' }}</p>
						    <div class="social-profile">
							    <ul>
								    @if (!empty($contentData['facebook_url']))
									    <li><a href="{{ $contentData['facebook_url'] }}"><i class="fab fa-facebook-f"></i></a></li>
								    @endif
								    @if (!empty($contentData['twitter_url']))
									    <li><a href="{{ $contentData['twitter_url'] }}"><i class="fab fa-twitter"></i></a></li>
								    @endif
								    @if (!empty($contentData['linkedin_url']))
									    <li><a href="{{ $contentData['linkedin_url'] }}"><i class="fab fa-linkedin-in"></i></a></li>
								    @endif
								    @if (!empty($contentData['pinterest_url']))
									    <li><a href="{{ $contentData['pinterest_url'] }}"><i class="fab fa-pinterest-p"></i></a></li>
								    @endif
							    </ul>
							    <span class="plus-btn"><i class="fas fa-share-alt"></i></span>
						    </div>
					    </div>
				    </div>
			    </div>
		    @endforeach
        </div>
    </div>
</section>
