@php
	use App\Models\PaymentGateway;
	$paymentGateways = PaymentGateway::allCached();
@endphp

<section class="brand-section fix section-padding">
	<div class="container">
		<div class="section-title text-center pb-4">
			@if (!empty($data['section_heading'][$locale]))
				<h4 class="brand-title">{{ $data['section_heading'][$locale] }}</h4>
			@endif
		</div>
		<div class="brand-wrapper">
			<div class="swiper brand-slider">
				<div class="swiper-wrapper">
					@foreach ($paymentGateways as $gateway)
						@if (!empty($gateway->logo))
							<div class="swiper-slide">
								<div class="brand-image center">
									<img src="{{ asset($gateway->logo) }}" alt="{{ $gateway->name }}">
								</div>
							</div>
						@endif
					@endforeach
				</div>
			</div>
		</div>
	</div>
</section>
