@php
	$locale = app()->getLocale();
	$blogs = \App\Models\Blog::activeCached()->take(3);
@endphp


<section class="news-section fix section-padding section-bg" id="blog">
    <div class="container">
        <div class="section-title-area">
            <div class="section-title mb-0">
                <span class="sub-title wow fadeInUp" style="visibility: visible; animation-name: fadeInUp;">
                    <img src="{{ asset($data['title_bar_image']) }}" alt="img" loading="lazy">
                    {{ $data['subheading'][$locale] ?? '' }}
                </span>
	            <h2 class="wow fadeInUp" data-wow-delay=".3s" style="visibility: visible; animation-delay: 0.3s; animation-name: fadeInUp;">
		            {{ $data['heading'][$locale] ?? '' }}
	            </h2>
            </div>
	        @if (!empty($data['button_text'][$locale]) && !empty($data['button_url']))
		        <a href="{{ $data['button_url'] }}" class="theme-btn wow fadeInUp" data-wow-delay=".5s" style="visibility: visible; animation-delay: 0.5s; animation-name: fadeInUp;">
			        {{ $data['button_text'][$locale] }}
		        </a>
	        @endif
        </div>
	    
	    <div class="news-wrapper">
            <div class="row g-4 align-items-center">
	            
	            {{-- First Large Blog --}}
	            @if(isset($blogs[0]))
		            <div class="col-lg-6 wow fadeInUp" data-wow-delay=".3s" style="visibility: visible; animation-delay: 0.3s; animation-name: fadeInUp;">
			            <div class="news-item">
				            <div class="news-image">
					            <div class="post-cat">
						            <span>{{ $blogs[0]->created_at->format('d') }}</span>
						            <p>{{ $blogs[0]->created_at->format('M') }}</p>
					            </div>
					            <img src="{{ asset($blogs[0]->thumbnail) }}" alt="img">
				            </div>
				            <div class="news-content">
					            <ul>
						            <li><i class="fa-solid fa-user"></i> {{ __('by') }} {{ $blogs[0]->author->name ?? 'Admin ' }}</li>
					            </ul>
					            <h5>
						            <a href="{{ route('blog.details', $blogs[0]->slug) }}">
							            {{ $blogs[0]->title_text }}
						            </a>
					            </h5>
				            </div>
			            </div>
		            </div>
	            @endif
	            
	            {{-- Second and Third Small Blogs --}}
                <div class="col-lg-6">
                    <div class="news-right-item">
	                    
	                    @foreach($blogs->skip(1) as $key => $blog)
		                    <div class="news-area @if($loop->last) mb-0 @endif wow fadeInUp" data-wow-delay=".{{ 4 + ($key * 2) }}s"
		                         style="visibility: visible; animation-delay:{{ 4 + ($key * 2) }}s; animation-name: fadeInUp;">
			                    <div class="news-thumb small-blog-thumb">
				                    <img src="{{ asset($blog->thumbnail) }}" alt="img">
			                    </div>
			                    <div class="news-content">
				                    <ul>
					                    <li><i class="fa-solid fa-user"></i> by {{ $blog->author->name ?? 'Admin' }}</li>
				                    </ul>
				                    <h5>
					                    <a href="{{ route('blog.details', $blog->slug) }}">
						                    {{ Str::limit($blog->title_text, 60) }}
					                    </a>
				                    </h5>
				                    <div class="post-cat">
					                    <span>{{ $blog->created_at->format('d') }}</span>
					                    <p>{{ $blog->created_at->format('M') }}</p>
				                    </div>
			                    </div>
		                    </div>
	                    @endforeach
                    
                    </div>
                </div>
            
            </div>
        </div>
    </div>
</section>
