@php
	$heading = $data['heading'][$locale] ?? '';
	$highlightedHeading = highlightWord($heading);
@endphp

<section class="hero-section hero-1 fix bg-cover" style="background-image: url('{{ asset($data['background_image'] ?? '') }}');" id="home">
	@if (!empty($data['shape_image_1']))
		<div class="hero-shape-1">
			<img src="{{ asset($data['shape_image_1']) }}" alt="Shape Image 1">
		</div>
	@endif
	
	@if (!empty($data['shape_image_2']))
		<div class="hero-shape-2">
			<img src="{{ asset($data['shape_image_2']) }}" alt="Shape Image 2">
		</div>
	@endif
	
	@if (!empty($data['shape_image_3']))
		<div class="hero-shape-3">
			<img src="{{ asset($data['shape_image_3']) }}" alt="Shape Image 3">
		</div>
	@endif
	
	<div class="container">
		<div class="row g-4 align-items-center justify-content-between">
			<div class="col-lg-4">
				<div class="hero-content">
					<h6 class="wow fadeInUp">
						{{ $data['subheading'][$locale] ?? '' }}
					</h6>
					<h1 class="wow fadeInUp" data-wow-delay=".3s">
						{!! $highlightedHeading !!}
					</h1>
					<p class="wow fadeInUp" data-wow-delay=".5s">
						{!! nl2br(e($data['description'][$locale] ?? '')) !!}
					</p>
					@if (!empty($data['button_url']) && !empty($data['button_text'][$locale]))
						<div class="hero-button wow fadeInUp" data-wow-delay=".7s">
							<a href="{{ $data['button_url'] }}" class="theme-btn">
								{{ $data['button_text'][$locale] }}
							</a>
						</div>
					@endif
				</div>
			</div>
			<div class="col-lg-8 wow fadeInUp" data-wow-delay=".4s">
				<div class="hero-image">
					<img src="{{ asset($data['hero_main_image']) }}" alt="Hero Main Image">
				</div>
			</div>
		</div>
	</div>
</section>
