@php
    use App\Enums\NotificationActionType;
	$notificationCount = $notifications->count();
@endphp

<div class="notice position-relative" role="button" data-bs-toggle="dropdown" aria-expanded="false"
     aria-label="Notifications">
    {{-- Mobile View: Show Different Icons Based on Notification Count --}}
    <div class="d-lg-none d-block">
        <x-icon name="{{ $notificationCount > 0 ? 'notice' : 'bell' }}" height="25" width="25" class="text-white"/>
    </div>
    
    {{-- Desktop View: Always Show Bell Icon with Notification Badge --}}
    <div class="d-lg-inline-block d-none position-relative">
        <x-icon name="notice-1" height="30" width="30" class="shadow-sm rounded-circle"/>
        @if($notificationCount > 0)
            <span>
                {{ $notificationCount < 9 ? $notificationCount : '9+' }}
            </span>
        @endif
    </div>
</div>

{{-- Notification Dropdown Menu --}}
<div class="dropdown-menu dropdown-menu-end single-card-box notification-dropdown p-1 shadow-sm" data-bs-display="static">
    
    <!--     Header -->
    <div class="d-flex justify-content-between align-items-center px-3 py-2 border-bottom bg-white">
        <span class="fw-semibold text-dark">
            {{ __('You have :count new notifications', ['count' => $notificationCount]) }}
        </span>
    </div>
    
    <!--     Notification List -->
    @if($notifications->isEmpty())
        <div class="text-center p-4 text-muted small">
            <i class="bi bi-inbox fs-2 opacity-50 d-block mb-2"></i>
            {{ __('No new notifications') }}
        </div>
    @else
        <div class="notification-list max-h-350 overflow-auto">
            @foreach($notifications->take(9) as $notification)
                @php
                    $data = $notification->data;
					$statusClass = NotificationActionType::getClass($data['action_type']);
                @endphp
                
                <a href="{{  $data['action_link'] ?? 'javascript:void(0)'  }}" data-id="{{ $notification->id }}"
                   class="d-flex align-items-start px-3 py-3 bg-white notification-item text-decoration-none read-notification">
                    
                    {{--Icon --}}
                    <div class="flex-shrink-0 me-3 mt-1">
                        <x-icon name="{{ $data['icon'] }}" class="text-{{ $statusClass }}" height="38" width="38"/>
                    </div>
                    
                    {{-- Content --}}
                    <div class="flex-grow-1">
                        <div class="d-flex justify-content-between">
                            <span class="fw-semibold text-dark">{{ $data['title'] }}</span>
                            <small class="text-muted ms-2">{{ $notification->created_at->diffForHumans() }}</small>
                        </div>
                        <div class="text-muted mt-1">{{ $data['message'] }}</div>
                    </div>
                </a>
                
                @if(!$loop->last)
                    <div class="notification-divider mx-3"></div>
                @endif
            @endforeach
        </div>
    @endif
    
    <!--     Footer -->
    <div class="px-3 py-2 border-top bg-white">
        <div class="d-flex flex-wrap flex-md-nowrap gap-2 w-100">

             @unless($notifications->isEmpty())
                <a href="{{ route('user.notifications.read-all') }}"
                   class="btn btn-sm btn-light-success flex-fill text-nowrap d-flex align-items-center justify-content-center">
                    <i class="fa fa-check-double me-1"></i>
                    {{ __('Mark all as read') }}
                </a>
            @endunless
            
            <a href="{{ route('user.notifications.index') }}"
               class="btn btn-sm btn-light-primary flex-fill text-nowrap d-flex align-items-center justify-content-center">
                <i class="fa fa-eye me-1"></i>
                {{ __('View all') }}
            </a>
        </div>
    </div>

</div>

@push('scripts')
    <script>
        'use strict';
        // Attach click event to mark notification as read
        $(document).on('click', '.read-notification', function () {
            'use strict';
            
            const notificationId = $(this).data('id');
            const url = "{{ route('user.notifications.markAsRead', ':id') }}".replace(':id', notificationId);
            
            // Make AJAX request to mark notification as read
            $.ajax({
                url: url,
                type: 'GET',
                data: {
                    _token: '{{ csrf_token() }}' // Ensure CSRF token is included
                },
                success: function (response) {
                    const notificationUrl = '{{ route('user.notifications.recent') }}';
                    $.get(notificationUrl, function (response) {
                        $('.append-new-notification').html(response); // Update notifications
                    });
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    console.error('Error marking notification as read:', textStatus, errorThrown);
                    // Optionally display an error message to the user
                }
            });
        });
    
    </script>
@endpush