<div class="fix-area sidebar-options">
    <div class="offcanvas__info">
        <div class="offcanvas__wrapper">
            <div class="offcanvas__content">
                <div class="offcanvas__top mb-5 d-flex justify-content-between align-items-center">
                    <div class="offcanvas__logo">
                        <a href="{{ route('home') }}">
                            <img src="{{ asset(setting('logo')) }}" alt="logo-img">
                        </a>
                    </div>
                    @include('frontend.layouts.partials._language_switcher',['textColor'=>'text-dark'])

                    <div class="offcanvas__close">
                        <button>
                            <i class="fas fa-times"></i>
                        </button>
                    </div>
                </div>
                <div class="mobile-menu fix mb-3">
                    @include('frontend.layouts.partials._menu_list')
                </div>
                <div class="offcanvas__contact">
                    <h4>{{ __('Contact Info') }}</h4>
                    <ul>
                        <li class="d-flex align-items-center">
                            <div class="offcanvas__contact-icon mr-15">
                                <i class="fal fa-envelope"></i>
                            </div>
                            <div class="offcanvas__contact-text">
                                <a href="mailto:{{ setting('support_email') }}"><span class="mailto:{{ setting('support_email') }}">{{ setting('support_email') }}</span></a>
                            </div>
                        </li>
                        <li class="d-flex align-items-center">
                            <div class="offcanvas__contact-icon mr-15">
                                <i class="fa-solid fa-phone"></i>
                            </div>
                            <div class="offcanvas__contact-text">
                                <a href="tel:{{ setting('support_phone') }}">{{ setting('support_phone') }}</a>
                            </div>
                        </li>
                    </ul>
                    <div class="header-button header-button d-flex align-items-center justify-content-center gap-4 mt-4">
                        @if(auth()->check())
                            <a href="{{ route('user.dashboard') }}" class="theme-btn style-border" >
                                {{ __('Dashboard') }}
                            </a>
                        @else
                            <a class="theme-btn style-border" href="{{ route('register') }}" >
                                {{ __('Register') }}
                            </a>
                            <a href="{{ route('login') }}" class="theme-btn" >
                                {{ __('Account Login') }}
                            </a>
                        @endif
                    </div>
                    @if($socials->isNotEmpty())
                        <div class="social-icon d-flex align-items-center">
                            @foreach($socials as $social)
                                <a href="{{ $social->url }}" target="{{ $social->target }}"><i class="{{ $social->icon_class }}"></i></a>
                            @endforeach
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
<div class="offcanvas__overlay"></div>
