@extends('frontend.layouts.auth')

@section('title', __('Two-Factor Authentication'))

@section('auth-content')
    <div class="min-vh-100 d-flex align-items-center justify-content-center bg-gray">
        <div class="bg-white col-11 col-sm-10 col-md-8 col-lg-6 col-xl-4 p-4 rounded style-shadow">

            {{-- Heading & Instructions --}}
            <div class="text-center mb-4">
                <img src="{{ asset(setting('logo')) }}" alt="Logo" class="img-fluid mb-3" style="max-width: 120px;">
                <h4 class="fw-bold">{{ __('Verify Your Identity') }}</h4>
                <p class="text-muted">
                    {{ __('Enter the 6-digit code from your Google Authenticator app to complete your login.') }}
                </p>
            </div>

            {{-- Error Handling --}}
            @if ($errors->any())
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    @foreach ($errors->all() as $error)
                        <strong>{{ $error }}</strong><br>
                    @endforeach
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif

            {{-- 2FA Verification Form --}}
            <form action="{{ route('user.two-factor-authenticate') }}" method="POST">
                @csrf
                <div class="mb-3">
                    <label for="verification_code"
                           class="form-label fw-semibold">{{ __('Enter Authentication Code') }}</label>
                    <input type="text" name="verification_code" id="verification_code" class="form-control text-center"
                           placeholder="••••••" required autofocus maxlength="6" pattern="\d{6}"
                           title="{{ __('Enter the 6-digit code from your authenticator app') }}">
                    @error('verification_code')
                    <span class="text-danger">{{ $message }}</span>
                    @enderror
                </div>

                {{-- Verify Button --}}
                <button type="submit" class="btn btn-primary w-100 mt-3">
                    <i class="fas fa-check-circle"></i> {{ __('Verify & Proceed') }}
                </button>
            </form>

            {{-- Additional Info --}}
            <div class="text-center mt-3">
                <p class="text-muted small">
                    {{ __("Make sure your device's time is synced correctly, as incorrect time settings may cause verification issues.") }}
                </p>
            </div>

        </div>
    </div>
@endsection
