<div class="modal fade" id="review-{{ $transaction->id }}" tabindex="-1" aria-labelledby="withdrawModalLabel"
     aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-md">
        <div class="modal-content">
            {{-- Modal Header --}}
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title fw-bold" id="withdrawModalLabel">{{ __('Withdrawal Details') }}</h5>
                <button type="button" class="btn-close btn-close-white" data-coreui-dismiss="modal"
                        aria-label="Close"></button>
            </div>

            <form action="{{ route('admin.deposit.request-action') }}" method="post">
                @csrf
                <input type="hidden" name="trx_id" value="{{ $transaction->trx_id }}">
                {{-- Modal Body --}}
                <div class="modal-body">
                    {{-- Withdrawal Information --}}
                    <div class="card border mb-3">
                        <div class="card-body p-3">
                            <h6 class="fw-bold text-primary mb-3">{{ __('Withdrawal Information') }}</h6>
                            <div class="d-flex justify-content-between mb-2">
                                <span class="fw-bold">{{ __('Transaction ID') }}</span>
                                <span>{{ $transaction->trx_id }}</span>
                            </div>
                            <div class="d-flex justify-content-between mb-2">
                                <span class="fw-bold">{{ __('Payment Method') }}</span>
                                <span class="text-uppercase fw-bold badge bg-info">{{ $transaction->provider }}</span>
                            </div>
                            <div class="d-flex justify-content-between">
                                <span class="fw-bold">{{ __('Amount to Withdraw') }}</span>
                                <span>{{ $transaction->net_amount . ' ' . $transaction->payable_currency }}</span>
                            </div>
                        </div>
                    </div>

                    {{-- Account Details --}}
                    <div class="card border mb-3">
                        <div class="card-body p-3">
                            <h6 class="fw-bold text-primary mb-3">{{ __('Account Details for Withdrawal') }}</h6>
                            @if(!empty($transaction->trx_data) && is_array($transaction->trx_data))
                                @foreach($transaction->trx_data as $data)
                                    @if(isset($data['type']) && $data['type'] === 'file')
                                        <div class="mb-3">
                                            <p class="fw-bold mb-1">{{ ucwords($data['name'] ?? 'Unnamed File') }}</p>
                                            @if(!empty($data['value']))
                                                <img src="{{ asset($data['value']) }}" alt="Uploaded File"
                                                     class="img-fluid rounded border">
                                            @else
                                                <p class="text-muted">{{ __('No file uploaded') }}</p>
                                            @endif
                                        </div>
                                    @else
                                        <div class="d-flex justify-content-between mb-2">
                                            <span class="fw-bold">{{ ucwords($data['name'] ?? 'Unknown Field') }}</span>
                                            <span>{{ $data['value'] ?? 'N/A' }}</span>
                                        </div>
                                    @endif
                                @endforeach
                            @else
                                <p class="text-muted">{{ __('No transaction data available') }}</p>
                            @endif

                        </div>
                    </div>

                    {{-- Remarks Section --}}
                    <div class="card border">
                        <div class="card-body p-3">
                            <h6 class="fw-bold text-primary mb-3">{{ __('Add Your Remarks (Optional)') }}</h6>
                            <textarea class="form-control" name="remarks" id="remarks" rows="3"
                                      placeholder="{{ __('Write your remarks here...') }}"></textarea>
                        </div>
                    </div>
                </div>

                {{-- Modal Footer --}}
                <div class="modal-footer bg-light p-3">
                    <div class="d-flex w-100">
                        <button type="submit" value="approve" name="action"
                                class="btn btn-success text-white w-50 d-flex align-items-center justify-content-center me-2">
                            <i class="fa-solid fa-check me-2"></i> {{ __('Approve Withdrawal') }}
                        </button>
                        <button type="submit" value="reject" name="action"
                                class="btn btn-danger text-white w-50 d-flex align-items-center justify-content-center">
                            <i class="fa-solid fa-times me-2"></i> {{ __('Reject Withdrawal') }}
                        </button>
                    </div>
                </div>
            </form>

        </div>
    </div>
</div>
