@extends('backend.withdraw.index')
@section('title', $type->label().' '. __('Methods'))
@section('withdraw_header')
    <div class="clearfix my-3">
        <div class="fs-3 fw-semibold float-start" >@yield('title')</div>
        <a href="#new_payment_method_modal" data-coreui-toggle="modal" class="btn btn-primary float-end">
            <x-icon name="add" class="icon"/>{{ __('Create').' '.  $type->label().' ' . __('Method') }}
        </a>
    </div>
@endSection

@section('withdraw_content')
    <div class="card border-0 mb-4">
        <div class="card-body">
            <div class="table-responsive rounded">
                <table class="table mb-0 caption-top">
                    <thead>
                    <tr>
                        <th>{{ __('Logo') }}</th>
                        <th>{{ __('Name|Currency') }}</th>
                        <th>{{ __('Min|Max withdraw') }}</th>
                        <th>{{ __('Rate Type|Rate') }}</th>
                        <th>{{ __('Charge') }}</th>
                        <th>{{ __('Status') }}</th>
                        @can('withdraw-method-manage')
                            <th>{{ __('Action') }}</th>
                        @endcan
                    </tr>
                    </thead>
                    <tbody>
                    @foreach($paymentMethods as $paymentMethod)
                        <tr class="align-middle">
                            <td>
                                <div class="position-relative me-3">
                                    <img src="{{ asset($paymentMethod->logo) }}" height="20" alt="">
                                </div>
                            </td>
                            <td>
                                <div class="text-nowrap"><strong
                                            class="text-muted">{{ title($paymentMethod->name) }}</strong></div>
                                <div class="small text-body-secondary text-nowrap">
                                    <span class="badge text-bg-secondary">
                                        {{ $paymentMethod->currency }}
                                    </span>
                                </div>
                            </td>

                            <td>
                                <div class="text-nowrap"><strong
                                            class="text-muted"> {{ $paymentMethod->currency_symbol }}{{ $paymentMethod->min_withdraw }} </strong>
                                </div>
                                <div class="small text-body-secondary text-nowrap"><strong
                                            class="text-muted"> {{ $paymentMethod->currency_symbol }}{{ $paymentMethod->max_withdraw }} </strong>
                                </div>
                            </td>

                            <td>
                                <div class="text-nowrap">
                                    @if($paymentMethod->conversion_rate_live)
                                        <strong class="text-danger">{{ __('LIVE') }}</strong>
                                    @else
                                        <strong class="text-primary">{{ __('LOCAL') }}</strong>
                                    @endif
                                </div>
                                <div class="small text-body-secondary text-nowrap ">
                                    <strong>1 {{ siteCurrency() }}
                                        = {{ $paymentMethod->conversion_rate }} {{ $paymentMethod->currency }}</strong>
                                </div>
                            </td>

                            <td>
                                <div class="text-nowrap">
                                    <strong class="text-muted">
                                        @if($paymentMethod->charge_type == App\Constants\FixPctType::PERCENT )
                                            {{ $paymentMethod->charge }}%
                                        @else
                                            {{ $paymentMethod->currency_symbol }}{{ $paymentMethod->charge }}
                                        @endif
                                    </strong>
                                </div>
                            </td>

                            <td class="text-nowrap text-uppercase">
                                @if($paymentMethod->status)
                                    <span class="badge bg-success">{{ __('Active') }}</span>
                                @else
                                    <span class="badge bg-danger">{{ __('Inactive') }}</span>
                                @endif
                            </td>
                            @can('withdraw-method-manage')
                                <td>
                                    <button type="button"
                                            data-edit-url="{{ route('admin.withdraw.method.edit', $paymentMethod->id) }}"
                                            class="btn btn-primary d-flex align-items-center edit-modal">
                                        <x-icon name="manage" height="20"/>
                                        {{ __('Manage') }}
                                    </button>
                                </td>
                            @endcan
                        </tr>
                    @endforeach
                    {{	$paymentMethods->links() }}
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    
    @can('withdraw-method-manage')
        @include('backend.withdraw.method.partials._new_payment_method_modal')
    
        @include('backend.withdraw.method.partials._edit_payment_method_modal')
    
        @php
            $fields = $paymentMethod->fields;
            $fieldCount = $fields ? count($fields) : 0;
        @endphp
    @endcan

@endsection
@push('scripts')
    @can('withdraw-method-manage')
        @include('backend.withdraw.method.partials._scripts')
    @endcan
@endpush
