@extends('backend.layouts.app')
@section('content')
    @php($withdrawMenu = getAdminMenuByCode('withdraw-management'))
    
    
    {{--Withdraw Header Dynamic Content Show Here--}}
    @yield('withdraw_header')

    <div class="card px-3 py-4">
        @if($withdrawMenu && isset($withdrawMenu['sub_menus']))
            <ul class="nav nav-pills bg-light rounded p-1">
                {{-- Withdraw Menu Load From admin_menus Config File --}}
                @foreach($withdrawMenu['sub_menus'] as $menu)
                    <li class="nav-item ">
                        <a class="nav-link {{ isActive($menu['route'],$menu['params'] ?? [] ) }}" aria-current="page"
                           href="{{ route($menu['route'], $menu['params'] ?? []) }}">
                            <x-icon name="{{ $menu['icon'] }}" height="18" width="18"/> {{ title($menu['label']) }}
                        </a>
                    </li>
                @endforeach
            </ul>
        @endif

        <div class="py-3">

            {{-- Withdraw Dynamic Content Show Here --}}
            @yield('withdraw_content')
        </div>
    </div>
@endSection
