@extends('backend.withdraw.index')
@section('title',  __('Withdraw History'))
@section('withdraw_header')
    <div class="clearfix my-3">
        <div class="fs-3 fw-semibold float-start">
            {{ __('Withdraw History') }}
        </div>
    </div>
@endSection

@section('withdraw_content')
    <div class="card border-0 mb-4">
        <div class="card-body">
            {{-- Filters --}}
            @include('backend.withdraw.partials._filter')
            
            {{-- Transactions Table --}}
            <div class="table-responsive">
                <table class="table  border mb-0">
                    <thead class="table-light fw-semibold">
                    <tr class="align-middle text-nowrap">
                        <th>{{ __('User | TXN ID') }}</th>
                        <th>{{ __('Amount | Fee') }}</th>
                        <th>{{ __('Description | Provider') }}</th>
                        <th>{{ __('Status') }}</th>
                        <th>{{ __('Time') }}</th>
                    </tr>
                    </thead>
                    <tbody>
                    @forelse($withdrawHistories as $withdrawHistory)
                        @php
                            $avatarData = getUserAvatarDetails($withdrawHistory->user->first_name, $withdrawHistory->user->last_name);
							$color = $withdrawHistory->status->color();
							$amountColor = $withdrawHistory->amount_flow->color($withdrawHistory->status);
							$amountSign = $withdrawHistory->amount_flow->sign($withdrawHistory->status);
                        @endphp
                        <tr class="align-middle">
                            {{-- User Information --}}
                            <td>
                                <div class="d-flex align-items-center">
                                    <div class="avatar avatar-md me-2">
                                        @isset($withdrawHistory->user->avatar)
                                            <img class="avatar-img" src="{{ asset($withdrawHistory->user->avatar) }}" height="40" alt="User Avatar">
                                        @else
                                            <div class="avatar avatar-md {{ $avatarData['class'] }} text-white">
                                                {{ $avatarData['initials'] }}
                                            </div>
                                        @endisset
                                    </div>
                                    <div>
                                        <a href="{{ route('admin.user.manage', $withdrawHistory->user->username) }}" class="text-decoration-none">
                                            {{ $withdrawHistory->user->name }}
                                        </a>
                                        <div class="small text-muted text-uppercase">{{ strtoupper($withdrawHistory->trx_id) }}</div>
                                    </div>
                                </div>
                            </td>
                            
                            {{-- Amount Information --}}
                            <td>
                                <div class="{{ $amountColor }} fw-bold">
                                    {{ $amountSign . $withdrawHistory->amount . ' ' . $withdrawHistory->currency }}
                                </div>
                                <div class="small text-muted">
                                    {{ __('Fee: :fee', ['fee' => getSymbol($withdrawHistory->currency) . $withdrawHistory->fee]) }}
                                </div>
                            </td>
                            
                            {{-- Description & Provider --}}
                            <td>
                                <div>{{ $withdrawHistory->description }}</div>
                                <div class="small text-muted">{{ $withdrawHistory->provider .' - '.$withdrawHistory->processing_type->label() }}</div>
                            </td>
                            
                            {{-- Status --}}
                            <td>
                                <span class="badge bg-{{ $color }} text-uppercase">{{ $withdrawHistory->status->label() }}</span>
                            </td>
                            
                            {{-- Transaction Time --}}
                            <td>
                                <div>{{ $withdrawHistory->created_at->format('Y-m-d H:i') }}</div>
                                <div class="small text-muted">{{ $withdrawHistory->created_at->diffForHumans() }}</div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="5" class="text-center py-3">
                                <div class="text-center py-5">
                                    <x-icon name="no-data-found" height="200"/>
                                    <h5 class="text-muted mt-2">{{ __('No Data found') }}</h5>
                                </div>
                            </td>
                        </tr>
                    @endforelse
                    </tbody>
                </table>
            </div>
            
            {{-- Pagination --}}
            <div class="d-flex justify-content-end mt-3">
                {{ $withdrawHistories->links() }}
            </div>
        </div>
    </div>
@endsection
