@php use App\Enums\TrxType; @endphp
<div class="modal fade" id="new_user_rank_modal" tabindex="-1" aria-labelledby="newUserRankModalLabel"
     aria-hidden="true">
    <div class="modal-dialog modal-md modal-dialog-centered">
        <div class="modal-content">
            {{-- Modal Header --}}
            <div class="modal-header">
                <h5 class="modal-title" id="newUserRankModalLabel">{{ __('Add New User Rank') }}</h5>
                <button type="button" class="btn-close" data-coreui-dismiss="modal" aria-label="Close"></button>
            </div>

            {{-- Modal Body --}}
            <div class="modal-body">
                <form action="{{ route('admin.ranking.store') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="row mb-3">
                        <div class="col-12">
                            <label class="form-label" for="icon">{{ __('Icon') }}</label>
                            <x-img name="icon"/>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label for="rank-name" class="form-label">{{ __('Name') }}</label>
                        <input type="text" class="form-control" id="rank-name" name="name" required
                               placeholder="{{ __('Enter rank name') }}">
                    </div>

                    <div class="mb-3">
                        <label for="rank-description" class="form-label">{{ __('Description') }}</label>
                        <input class="form-control" id="rank-description" name="description" rows="3" required
                               placeholder="{{ __('Enter rank description') }}"></input>
                    </div>

                    <div class="row mb-3">
                        <div class="col-6">
                            <label for="trx-amount" class="form-label">{{ __('Transaction Amount') }}</label>
                            <div class="input-group">
                                <input type="text" class="form-control" name="transaction_amount"
                                       oninput="this.value = validateDouble(this.value)"
                                       aria-label="Amount (to the nearest dollar)">
                                <span class="input-group-text">{{ siteCurrency() }}</span>
                            </div>
                        </div>
                        <div class="col-6">
                            <label for="trx-amount" class="form-label">{{ __('Rank Reward') }}</label>
                            <div class="input-group">
                                <input type="text" class="form-control" name="reward"
                                       oninput="this.value = validateDouble(this.value)"
                                       aria-label="Amount (to the nearest dollar)">
                                <span class="input-group-text">{{ siteCurrency() }}</span>
                            </div>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">{{ __('Allow Transaction Type') }}</label>
                        <div>
                            @foreach(TrxType::userRankSupport() as $trxType)
                                @php($trxType = $trxType->value)
                                <div class="form-check form-check-inline">
                                    <input class="form-check-input" type="checkbox" name="transaction_types[]"
                                           id="trx-type-{{ $trxType }}" value="{{ $trxType }}">
                                    <label class="form-check-label"
                                           for="trx-type-{{ $trxType }}">{{ title($trxType) }}</label>
                                </div>
                            @endforeach
                        </div>
                    </div>

                    <div class="row mb-3">
                        <div class="col-6">
                            <label for="trx-amount" class="form-label">{{ __('Max Wallet Create') }}</label>
                            <div class="input-group">
                                <input type="text" class="form-control" name="features[wallet_create]"
                                       oninput="this.value = validateDouble(this.value)"
                                       aria-label="Wallet Create">
                                <span class="input-group-text">{{ __('Wallet') }}</span>
                            </div>
                        </div>
                        <div class="col-6">
                            <label for="trx-amount" class="form-label">{{ __('Max Referral Level') }}</label>
                            <div class="input-group">
                                <input type="text" class="form-control" name="features[referral_level]"
                                       oninput="this.value = validateDouble(this.value)"
                                       aria-label="Referral Level">
                                <span class="input-group-text">{{ __('Level') }}</span>
                            </div>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">{{ __('Status') }}</label>
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" id="is-active" name="is_active" value="1"
                                   checked>
                            <label class="form-check-label" for="is-active">{{ __('Active') }}</label>
                        </div>
                    </div>

                    {{-- Modal Footer --}}
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary"
                                data-coreui-dismiss="modal">{{ __('Cancel') }}</button>
                        <button type="submit" class="btn btn-primary">{{ __('Save') }}</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
