@php use App\Enums\TrxType; @endphp
@extends('backend.layouts.app')
@section('title', __('User Ranks'))
@section('content')
    <div class="clearfix my-3">
        <div class="fs-4 fw-semibold float-start">{{ __('User Ranks Management') }}</div>
        <a href="#new_user_rank_modal" data-coreui-toggle="modal" class="btn btn-primary float-end">
            <x-icon name="add" class="icon"/>{{ __('Add New') }}</a>
    </div>
    <div class="card border-0 mb-4">
        <div class="card-body px-2">
            <div class="table-responsive">
                <table class="table user-table align-items-center">
                    <thead class="table-light">
                    <tr>
                        <th>{{ __('Name') . ' | ' . __('Description') }}</th>
                        <th>{{ __('Trx Amount | Reward')  }}</th>
                        <th>{{ __('Trx Type Allowed') }}</th>
                        <th>{{ __('Status') }}</th>
                        <th>{{ __('Action') }}</th>
                    </tr>
                    </thead>
                    <tbody>
                    @foreach($userRanks as $userRank)
                        <tr class="align-middle ">
                            <td>
                                <div class="d-flex align-items-center">
                                    <img class="avatar rounded me-2" width="36" height="36"
                                         src="{{ asset($userRank->icon) }}" alt="User Avatar">
                                    <div>
                                        <div class="text-nowrap">
                                            {{ $userRank->name }}
                                            @if($userRank->is_default)
                                                <span class="badge badge-sm bg-success">{{ __('Default') }}</span>
                                            @endif
                                        </div>
                                        <div class="small text-muted">
                                            {{ \Illuminate\Support\Str::limit($userRank->description, 70) }}
                                        </div>
                                    </div>
                                </div>
                            </td>
                            <td>
                                <div class="fw-bold">
                                    {{ $userRank->transaction_amount .' '. siteCurrency() }}
                                </div>
                                <div class="text-muted small">
                                    {{ $userRank->reward .' '. siteCurrency() }}
                                </div>
                            </td>
                            <td>
                                @foreach($userRank->transaction_types as $transactionType)
                                    <span class="badge bg-{{ TrxType::getBadgesColor([$transactionType]) }} form-badge-inline ">{{ title($transactionType) }}</span>
                                @endforeach
                            </td>
                            <td>
                                <span class="badge bg-{{ $userRank->is_active ? 'success' : 'danger' }} ">{{ strtoupper($userRank->is_active ? 'active' : 'inactive') }}</span>
                            </td>
                            <td class="fw-bold">
                                <button type="button" data-edit-url="{{ route('admin.ranking.edit', $userRank->id) }}"
                                        class="btn btn-primary edit-modal">
                                    <x-icon name="manage" height="20"/>
                                    {{ __('Manage') }}
                                </button>
                            </td>
                        </tr>
                    @endforeach
                    </tbody>
                </table>
            </div>

        </div>
    </div>


    @include('backend.user_rank.partials._new_user_rank_modal')
    @include('backend.user_rank.partials._edit_user_rank_modal')

@endsection
@push('scripts')
    <script>
        $(document).ready(function () {
            editFormByModal('edit_user_rank_modal', 'edit_user_rank_data',true , true);
        });
    </script>
@endpush
