<script>
    "use strict";

    $(function () {
        // Cache selectors
        const $walletSelect = $("#walletSelect");
        const $currencyCode = $("#currencyCode");

        // Feature Toggle Change
        $(document).on("change", ".feature-switch", function () {
            updateFeatureStatus($(this));
        });

        // Show Modals
        $(document).on("click", ".notify-user", () => $("#notifyUserModal").modal("show"));
        $(document).on("click", ".add-money", () => $("#balanceModal").modal("show"));

        // Wallet Selection - Update Currency Code
        $walletSelect.on("change", function () {
            const currency = $(this).find(":selected").data("currency") || "{{ __('Not Selected') }}";
            $currencyCode.text(currency);
        });

        /**
         * Update User Feature Status via AJAX
         * @param {object} $element - The checkbox element
         */
        function updateFeatureStatus($element) {
            const userId = $element.data("user-id");
            const feature = $element.data("feature");
            const status = $element.prop("checked") ? 1 : 0;

            $.post("{{ route('admin.user.feature-status.update') }}", {
                _token: "{{ csrf_token() }}",
                user_id: userId,
                feature: feature,
                status: status
            })
                .done(response => notifyEvs(response.type, response.message))
                .fail(xhr => {
                    console.error("Error:", xhr.responseText);
                    notifyEvs("error", "An error occurred while updating the feature status.");
                });
        }
    });
</script>
